/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.repository;

import com.intellij.jpa.jpb.model.repository.AbstractRepositoryMethodQueryProvider;
import com.intellij.jpa.model.common.persistence.mapping.NamedQuery;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.data.jpa.SpringDataJpaUtil;
import com.intellij.spring.data.jpa.ql.language.SpringDataQLLanguage;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/data/jpa/repository/JpaRepositoryMethodNamedQueryProvider;", "Lcom/intellij/jpa/jpb/model/repository/AbstractRepositoryMethodQueryProvider;", "<init>", "()V", "getOrCreateQLStatement", "Lcom/intellij/psi/PsiElement;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "entityClass", "Lcom/intellij/psi/PsiClass;", "findNamedQuery", "", "intellij.spring.data.jpa"})
public final class JpaRepositoryMethodNamedQueryProvider
extends AbstractRepositoryMethodQueryProvider {
    @Nullable
    public PsiElement getOrCreateQLStatement(@NotNull UMethod uMethod, @Nullable PsiClass entityClass) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        String string = this.findNamedQuery(uMethod);
        if (string == null) {
            return null;
        }
        String queryString = string;
        Project project = uMethod.getJavaPsi().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)uMethod.getJavaPsi()));
        SpringDataQLLanguage springDataQLLanguage = SpringDataQLLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)springDataQLLanguage, (String)"INSTANCE");
        return this.createQueryElementFromString(project, module, (Language)springDataQLLanguage, this.getQueryName(uMethod), queryString);
    }

    private final String findNamedQuery(UMethod uMethod) {
        Set<NamedQuery> set = SpringDataJpaUtil.getNamedQueries(uMethod.getJavaPsi());
        Intrinsics.checkNotNullExpressionValue(set, (String)"getNamedQueries(...)");
        Set<NamedQuery> namedQueries = set;
        NamedQuery namedQuery = (NamedQuery)CollectionsKt.firstOrNull((Iterable)namedQueries);
        return namedQuery != null && (namedQuery = namedQuery.getQuery()) != null ? (String)namedQuery.getValue() : null;
    }
}

