/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.attributetotag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.attributetotag.AttributeToTagUsageViewDescriptor;
import com.sixrr.xrp.attributetotag.ReplaceAttributeWithTag;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.psi.XMLMutationUtils;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class AttributeToTagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final String tagName;
    private final Context context;

    @VisibleForTesting
    public AttributeToTagProcessor(XmlAttribute attribute, String tagName, Context context) {
        super(attribute.getProject());
        this.attribute = attribute;
        this.tagName = tagName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            AttributeToTagProcessor.$$$reportNull$$$0(0);
        }
        return new AttributeToTagUsageViewDescriptor(this.attribute);
    }

    @Override
    public void findUsages(@NotNull List<? super XRPUsageInfo> usages) {
        if (usages == null) {
            AttributeToTagProcessor.$$$reportNull$$$0(1);
        }
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        XmlTag parentTag = this.attribute.getParent();
        String existingTagName = parentTag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(existingTagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlAttribute foundAttribute;
            if (XMLMutationUtils.isSpecialJSPTag(xmlTag) || (foundAttribute = xmlTag.getAttribute(attributeName, attributeNamespace)) == null) continue;
            usages.add(new ReplaceAttributeWithTag(xmlTag, this.tagName, attributeName, attributeNamespace));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactorXBundle.message("command.name.replace.attribute.with.tag", this.attribute.getName());
        if (string == null) {
            AttributeToTagProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/attributetotag/AttributeToTagProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/attributetotag/AttributeToTagProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

