/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityPropertiesProvider {
    private static final String VELOCIMACRO_LIBRARY_PROPERTY = "velocimacro.library";
    private static final String FILE_RESOURCE_LOADER_PATH_PROPERTY = "file.resource.loader.path";
    private final PropertiesFile myPropertiesFile;
    @Nullable
    private final VirtualFile myRuntimeRoot;

    public VelocityPropertiesProvider(@NotNull PropertiesFile file, @Nullable VirtualFile runtimeRoot) {
        if (file == null) {
            VelocityPropertiesProvider.$$$reportNull$$$0(0);
        }
        this.myPropertiesFile = file;
        this.myRuntimeRoot = runtimeRoot;
    }

    public VelocityPropertiesProvider(@NotNull PropertiesFile file) {
        if (file == null) {
            VelocityPropertiesProvider.$$$reportNull$$$0(1);
        }
        this.myPropertiesFile = file;
        this.myRuntimeRoot = null;
    }

    @NotNull
    public List<VirtualFile> getResourceLoaderPathListBasedOn(@Nullable VirtualFile baseFile) {
        if (this.myRuntimeRoot != null) {
            baseFile = this.myRuntimeRoot;
        }
        if (baseFile == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                VelocityPropertiesProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
        for (String loaderPath : this.getResourceLoaderPathList()) {
            VirtualFile loaderPathFile = baseFile.findFileByRelativePath(loaderPath);
            if (loaderPathFile == null) continue;
            res.add(loaderPathFile);
        }
        ArrayList<VirtualFile> arrayList = res;
        if (arrayList == null) {
            VelocityPropertiesProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public String[] getResourceLoaderPathList() {
        String[] stringArray;
        String value = this.getValue(FILE_RESOURCE_LOADER_PATH_PROPERTY);
        if (value.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".";
        } else {
            stringArray = VelocityPropertiesProvider.splitAndTrim(value);
        }
        return stringArray;
    }

    private static String[] splitAndTrim(String values) {
        String[] array = values.split(",");
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }

    @NotNull
    public List<VtlFile> getVelocimacroLibraryListBasedOn(@Nullable VirtualFile baseFile) {
        if (this.myRuntimeRoot != null) {
            baseFile = this.myRuntimeRoot;
        }
        String[] libNames = this.getVelocimacroLibraryNames();
        if (baseFile == null || libNames.length == 0) {
            List<VtlFile> list = Collections.emptyList();
            if (list == null) {
                VelocityPropertiesProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiManager manager = this.myPropertiesFile.getContainingFile().getManager();
        ArrayList<VtlFile> res = new ArrayList<VtlFile>();
        for (VirtualFile loaderPathFile : this.getResourceLoaderPathListBasedOn(baseFile)) {
            for (int i = libNames.length - 1; i >= 0; --i) {
                PsiFile libPsiFile;
                FileViewProvider viewProvider;
                VirtualFile libFile = loaderPathFile.findFileByRelativePath(libNames[i]);
                if (libFile == null || (viewProvider = manager.findViewProvider(libFile)) == null || !((libPsiFile = viewProvider.getPsi((Language)VtlLanguage.INSTANCE)) instanceof VtlFile)) continue;
                ContainerUtil.addIfNotNull(res, (Object)((VtlFile)libPsiFile));
            }
        }
        ArrayList<VtlFile> arrayList = res;
        if (arrayList == null) {
            VelocityPropertiesProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public PropertiesFile getPropertiesFile() {
        PropertiesFile propertiesFile = this.myPropertiesFile;
        if (propertiesFile == null) {
            VelocityPropertiesProvider.$$$reportNull$$$0(6);
        }
        return propertiesFile;
    }

    public String @NotNull [] getVelocimacroLibraryNames() {
        String value = this.getValue(VELOCIMACRO_LIBRARY_PROPERTY);
        String[] stringArray = value.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : VelocityPropertiesProvider.splitAndTrim(value);
        if (stringArray == null) {
            VelocityPropertiesProvider.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @NotNull
    private String getValue(@NotNull @NonNls String key) {
        IProperty resourceLoaderPathProp;
        if (key == null) {
            VelocityPropertiesProvider.$$$reportNull$$$0(8);
        }
        if ((resourceLoaderPathProp = this.myPropertiesFile.findPropertyByKey(key)) == null) {
            return "";
        }
        String val = resourceLoaderPathProp.getValue();
        return val != null ? val : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/files/VelocityPropertiesProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/files/VelocityPropertiesProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceLoaderPathListBasedOn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVelocimacroLibraryListBasedOn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVelocimacroLibraryNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

