/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging.jpackage;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.packaging.jpackage.JPackageArtifactProperties;

public final class JPackageArtifactPropertiesEditor
extends ArtifactPropertiesEditor {
    private final JPackageArtifactProperties myProperties;
    private final Project myProject;
    private TextFieldWithBrowseButton myMainClass;
    private JTextField myVersion;
    private JTextField myCopyright;
    private JTextField myVendor;
    private JBTextArea myDescription;
    private JCheckBox myVerbose;

    public JPackageArtifactPropertiesEditor(JPackageArtifactProperties properties, @NotNull Project project) {
        if (project == null) {
            JPackageArtifactPropertiesEditor.$$$reportNull$$$0(0);
        }
        this.myProperties = properties;
        this.myProject = project;
    }

    @Nls
    public String getTabName() {
        return JavaFXBundle.message("packaging.artifact.tab.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        TreeClassChooserFactory chooserFactory = TreeClassChooserFactory.getInstance((Project)this.myProject);
        this.myMainClass = new TextFieldWithBrowseButton(e -> {
            TreeClassChooser classChooser = chooserFactory.createWithInnerClassesScopeChooser(ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0]), GlobalSearchScope.projectScope((Project)this.myProject), PsiMethodUtil::hasMainMethod, null);
            classChooser.showDialog();
            PsiClass selectedClass = classChooser.getSelected();
            if (selectedClass == null) {
                return;
            }
            this.myMainClass.setText(selectedClass.getQualifiedName());
        });
        this.myMainClass.setText(this.myProperties.mainClass);
        this.myVersion = new JTextField(this.myProperties.version);
        this.myCopyright = new JTextField(this.myProperties.copyright);
        this.myVendor = new JTextField(this.myProperties.vendor);
        this.myDescription = new JBTextArea(this.myProperties.description, 5, 50);
        this.myDescription.setMinimumSize(new Dimension(100, 50));
        this.myVerbose = new JCheckBox(JavaFXBundle.message("show.verbose.output.when.building.the.platform.specific.package", new Object[0]), this.myProperties.verbose);
        FormBuilder builder = new FormBuilder();
        builder.addLabeledComponent(JavaFXBundle.message("label.main.class", new Object[0]), (JComponent)this.myMainClass);
        builder.addLabeledComponent(JavaFXBundle.message("label.version", new Object[0]), (JComponent)this.myVersion);
        builder.addLabeledComponent(JavaFXBundle.message("label.copyright", new Object[0]), (JComponent)this.myCopyright);
        builder.addLabeledComponent(JavaFXBundle.message("label.vendor", new Object[0]), (JComponent)this.myVendor);
        builder.addLabeledComponent(JavaFXBundle.message("label.description", new Object[0]), (JComponent)new JBScrollPane((Component)this.myDescription));
        builder.addComponent((JComponent)this.myVerbose);
        return builder.getPanel();
    }

    public boolean isModified() {
        if (JPackageArtifactPropertiesEditor.isModified(this.myProperties.mainClass, this.myMainClass.getTextField())) {
            return true;
        }
        if (JPackageArtifactPropertiesEditor.isModified(this.myProperties.version, this.myVersion)) {
            return true;
        }
        if (JPackageArtifactPropertiesEditor.isModified(this.myProperties.copyright, this.myCopyright)) {
            return true;
        }
        if (JPackageArtifactPropertiesEditor.isModified(this.myProperties.vendor, this.myVendor)) {
            return true;
        }
        if (JPackageArtifactPropertiesEditor.isModified(this.myProperties.description, (JTextComponent)this.myDescription)) {
            return true;
        }
        return this.myProperties.verbose != this.myVerbose.isSelected();
    }

    private static boolean isModified(String title, JTextComponent tf) {
        return !Comparing.strEqual((String)title, (String)tf.getText().trim());
    }

    public void apply() {
        this.myProperties.mainClass = this.myMainClass.getText();
        this.myProperties.version = this.myVersion.getText();
        this.myProperties.copyright = this.myCopyright.getText();
        this.myProperties.vendor = this.myVendor.getText();
        this.myProperties.description = this.myDescription.getText();
        this.myProperties.verbose = this.myVerbose.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/packaging/jpackage/JPackageArtifactPropertiesEditor", "<init>"));
    }
}

