/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.util;

import com.intellij.psi.xml.XmlElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.xpathView.util.Variable;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;

public class CachedVariableContext
implements VariableContext {
    private final Map<String, Object> myMap = new HashMap<String, Object>();

    public CachedVariableContext(Collection<Variable> variables, XPath xpath, XmlElement contextNode) throws SAXPathException {
        for (Variable variable : variables) {
            if (variable.getName().isEmpty()) continue;
            String expression = variable.getExpression();
            XPath xPath = xpath.getNavigator().parseXPath(expression.isEmpty() ? "/.." : expression);
            this.myMap.put(variable.getName(), xPath.evaluate((Object)contextNode));
        }
    }

    public Object getVariableValue(String nsURI, String prefix, String localName) throws UnresolvableException {
        Object o = this.myMap.get(localName);
        if (o == null) {
            throw new UnresolvableException("Unresolved variable: " + CachedVariableContext.makePrefix(nsURI) + localName);
        }
        return o;
    }

    private static String makePrefix(String uri) {
        return uri != null ? "{" + uri + "}:" : "";
    }
}

