/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k1.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.kotlin.jupyter.core.editor.highlighting.utils.NotebookHighlightingUtilityObject;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.util.LoggingKt;
import com.intellij.kotlin.jupyter.k1.highlighting.KotlinNotebookHighlightingErrorFilterKt;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/k1/highlighting/KotlinNotebookHighlightingErrorFilter;", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoFilter;", "<init>", "()V", "shouldAcceptFile", "", "Lcom/intellij/psi/PsiFile;", "accept", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "file", "Companion", "intellij.kotlin.jupyter.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookHighlightingErrorFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookHighlightingErrorFilter.kt\ncom/intellij/kotlin/jupyter/k1/highlighting/KotlinNotebookHighlightingErrorFilter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n23#2:69\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookHighlightingErrorFilter.kt\ncom/intellij/kotlin/jupyter/k1/highlighting/KotlinNotebookHighlightingErrorFilter\n*L\n52#1:69\n*E\n"})
public final class KotlinNotebookHighlightingErrorFilter
implements HighlightInfoFilter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;

    private final boolean shouldAcceptFile(PsiFile $this$shouldAcceptFile) {
        Project project = $this$shouldAcceptFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String notebookExtension = JupyterCompilerService.Companion.getInstance(project).getFileExtension();
        String string = $this$shouldAcceptFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)notebookExtension, (boolean)false, (int)2, null);
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        boolean isMissingDependency;
        boolean isTargetHost;
        Intrinsics.checkNotNullParameter((Object)highlightInfo, (String)"highlightInfo");
        if (file == null || !this.shouldAcceptFile(file)) {
            return true;
        }
        boolean bl = isTargetHost = file.getUserData(NotebookHighlightingUtilityObject.INSTANCE.getNonTargetHostErrorMark()) == null;
        if (!isTargetHost) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)highlightInfo.getSeverity(), (Object)HighlightSeverity.ERROR)) {
            return true;
        }
        String string = highlightInfo.getDescription();
        if (string == null) {
            return true;
        }
        String description = string;
        boolean isMissingBaseClass = KotlinNotebookHighlightingErrorFilterKt.access$isMissingBaseDependencyError(description);
        boolean isMissingReceiverClass = KotlinNotebookHighlightingErrorFilterKt.access$isMissingImplicitReceiverError(description);
        boolean bl2 = isMissingDependency = isMissingBaseClass || isMissingReceiverClass;
        if (isMissingDependency) {
            LoggingKt.reportErrorTestAware((Logger)LOG, (String)(isMissingBaseClass ? "Missing base script class" : "Missing script receiver class: " + description), (Attachment)new Attachment(file.getName(), file.getText()));
        }
        return !isMissingDependency;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/k1/highlighting/KotlinNotebookHighlightingErrorFilter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.k1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

