/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.toolwindow.panels;

import com.intellij.microservices.jvm.beans.BeansElementItem;
import com.intellij.microservices.jvm.beans.BeansListItem;
import com.intellij.microservices.jvm.beans.BeansSidePanel;
import com.intellij.microservices.jvm.beans.BeansSidePanelProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.diagrams.SpringGraphBundle;
import com.intellij.spring.diagrams.perspectives.SpringBeanGraphPanelContent;
import com.intellij.spring.diagrams.toolwindow.panels.SpringBeanPointerGraphPanelProviderKt;
import com.intellij.spring.toolWindow.beans.SpringBeanItem;
import com.intellij.spring.toolWindow.beans.SpringBeansGroup;
import com.intellij.ui.components.JBPanelWithEmptyText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/diagrams/toolwindow/panels/SpringBeanPointerGraphPanelProvider;", "Lcom/intellij/microservices/jvm/beans/BeansSidePanelProvider;", "<init>", "()V", "create", "Lcom/intellij/microservices/jvm/beans/BeansSidePanel;", "project", "Lcom/intellij/openapi/project/Project;", "SpringBeanPointerGraphPanel", "intellij.spring.graph"})
public final class SpringBeanPointerGraphPanelProvider
implements BeansSidePanelProvider {
    @NotNull
    public BeansSidePanel create(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new SpringBeanPointerGraphPanel(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0016\u0010\u001c\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/spring/diagrams/toolwindow/panels/SpringBeanPointerGraphPanelProvider$SpringBeanPointerGraphPanel;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/microservices/jvm/beans/BeansSidePanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "mainPanel", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "disposable", "Lcom/intellij/openapi/Disposable;", "delegate", "Lcom/intellij/spring/diagrams/perspectives/SpringBeanGraphPanelContent;", "title", "", "getTitle", "()Ljava/lang/String;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "isAvailable", "", "selectedItems", "", "Lcom/intellij/microservices/jvm/beans/BeansListItem;", "isVisible", "update", "", "isActive", "intellij.spring.graph"})
    private static final class SpringBeanPointerGraphPanel
    extends UserDataHolderBase
    implements BeansSidePanel {
        @NotNull
        private final Project project;
        @NotNull
        private final JBPanelWithEmptyText mainPanel;
        @Nullable
        private Disposable disposable;
        @NotNull
        private final SpringBeanGraphPanelContent delegate;

        public SpringBeanPointerGraphPanel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.mainPanel = new JBPanelWithEmptyText();
            this.delegate = new SpringBeanGraphPanelContent();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
            this.mainPanel.getEmptyText().setText(SpringGraphBundle.message("spring.bean.graph.tab.empty.text", new Object[0]));
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public String getTitle() {
            String string = SpringGraphBundle.message("spring.bean.graph.tab.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public JComponent getComponent() {
            return (JComponent)this.mainPanel;
        }

        public boolean isAvailable(@NotNull List<? extends BeansListItem> selectedItems) {
            Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
            BeansListItem beansListItem = (BeansListItem)CollectionsKt.singleOrNull(selectedItems);
            if (beansListItem == null) {
                return false;
            }
            BeansListItem item = beansListItem;
            if (!(item instanceof BeansElementItem)) {
                return false;
            }
            Object bean = ((BeansElementItem)item).getBean();
            if (!(bean instanceof SpringBeanItem)) {
                return false;
            }
            Object group = ((BeansElementItem)item).getGroup();
            return group instanceof SpringBeansGroup;
        }

        public boolean isVisible(@NotNull List<? extends BeansListItem> selectedItems) {
            Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
            return true;
        }

        public void update(@NotNull List<? extends BeansListItem> selectedItems, boolean isActive) {
            Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
            this.mainPanel.removeAll();
            if (this.disposable != null) {
                Disposable disposable = this.disposable;
                Intrinsics.checkNotNull((Object)disposable);
                Disposer.dispose((Disposable)disposable);
                this.disposable = null;
            }
            if (!isActive) {
                return;
            }
            BeansListItem beansListItem = (BeansListItem)CollectionsKt.singleOrNull(selectedItems);
            if (beansListItem == null) {
                return;
            }
            BeansListItem item = beansListItem;
            if (!(item instanceof BeansElementItem)) {
                return;
            }
            Object bean = ((BeansElementItem)item).getBean();
            if (!(bean instanceof SpringBeanItem)) {
                return;
            }
            Object group = ((BeansElementItem)item).getGroup();
            if (!(group instanceof SpringBeansGroup)) {
                return;
            }
            this.disposable = Disposer.newDisposable();
            Disposable disposable = (Disposable)this.project;
            Disposable disposable2 = this.disposable;
            Intrinsics.checkNotNull((Object)disposable2);
            Disposer.register((Disposable)disposable, (Disposable)disposable2);
            JComponent diagramComponent = this.delegate.createComponent(this.project, (UserDataHolder)this, this.disposable, SpringBeanPointerGraphPanelProviderKt.access$getProvider(() -> SpringBeanPointerGraphPanel.update$lambda$0(group), ((SpringBeanItem)bean).getPointer()), true);
            this.mainPanel.add((Component)diagramComponent, (Object)"Center");
            this.delegate.update((UserDataHolder)this);
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }

        private static final CommonSpringModel update$lambda$0(Object $group) {
            return ((SpringBeansGroup)$group).getModel();
        }
    }
}

