/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlDeclarationHolder;
import com.intellij.freemarker.psi.directives.ResolveStateParameters;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.concurrent.ConcurrentMap;

public abstract class FtlDeclarationCache<T extends FtlXmlTag> {
    private CachedValue<ConcurrentMap<ResolveStateParameters, FtlDeclarationHolder>> myDirectiveCache;
    protected final T myTag;

    public FtlDeclarationCache(T tag) {
        this.myTag = tag;
    }

    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, boolean honorAssigns) {
        CachedValue cache = this.myDirectiveCache;
        if (cache == null) {
            cache = this.myDirectiveCache = CachedValuesManager.getManager((Project)this.myTag.getProject()).createCachedValue(() -> {
                ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> this.calcDeclarationHolder((ResolveStateParameters)key));
                return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
        }
        return ((FtlDeclarationHolder)((ConcurrentMap)cache.getValue()).get(new ResolveStateParameters(honorAssigns, state))).processDirectiveDeclarations(processor, state);
    }

    protected abstract FtlDeclarationHolder calcDeclarationHolder(ResolveStateParameters var1);
}

