/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml;

import com.intellij.ide.presentation.Presentation;
import com.intellij.spring.model.values.converters.resources.ResourceValueConverter;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.spring.security.model.xml.SpringSecurityDomElement;
import com.intellij.spring.security.model.xml.User;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Referencing;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="User Service")
@BeanType(provider=UserServiceBeanTypeProvider.class)
public interface UserService
extends DomSpringBean,
SpringSecurityDomElement {
    @Referencing(value=ResourceValueConverter.class)
    @NotNull
    public GenericAttributeValue<String> getProperties();

    @NotNull
    public List<User> getUsers();

    public static class UserServiceBeanTypeProvider
    implements BeanTypeProvider<UserService> {
        @NotNull
        public String[] getBeanTypeCandidates() {
            String[] stringArray = new String[]{"org.springframework.security.provisioning.InMemoryUserDetailsManager", "org.springframework.security.core.userdetails.memory.InMemoryDaoImpl", "org.springframework.security.userdetails.memory.InMemoryDaoImpl"};
            if (stringArray == null) {
                UserServiceBeanTypeProvider.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        @Nullable
        public String getBeanType(UserService service) {
            SpringSecurityVersion version = SpringSecurityUtil.getVersion(service);
            if (version.isAtLeast(SpringSecurityVersion.V_3_1)) {
                return "org.springframework.security.provisioning.InMemoryUserDetailsManager";
            }
            if (version.isAtLeast(SpringSecurityVersion.V_3_0)) {
                return "org.springframework.security.core.userdetails.memory.InMemoryDaoImpl";
            }
            return "org.springframework.security.userdetails.memory.InMemoryDaoImpl";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/UserService$UserServiceBeanTypeProvider", "getBeanTypeCandidates"));
        }
    }
}

