/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B?\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012(\u0010\u0006\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/SpecificLibraryResolver;", "T", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "kClass", "Lkotlin/reflect/KClass;", "resolveRaw", "Lkotlin/Function2;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorGlobalOptions;", "<init>", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function2;)V", "getResolveRaw", "()Lkotlin/jvm/functions/Function2;", "accepts", "", "reference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "resolve", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "arguments", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "shared-compiler"})
public final class SpecificLibraryResolver<T extends LibraryResolutionInfo>
implements LibraryResolver {
    @NotNull
    private final KClass<T> kClass;
    @NotNull
    private final Function2<T, String, Pair<String, LibraryDescriptorGlobalOptions>> resolveRaw;

    public SpecificLibraryResolver(@NotNull KClass<T> kClass, @NotNull Function2<? super T, ? super String, ? extends Pair<String, ? extends LibraryDescriptorGlobalOptions>> resolveRaw) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(resolveRaw, (String)"resolveRaw");
        this.kClass = kClass;
        this.resolveRaw = resolveRaw;
    }

    @NotNull
    public final Function2<T, String, Pair<String, LibraryDescriptorGlobalOptions>> getResolveRaw() {
        return this.resolveRaw;
    }

    public final boolean accepts(@NotNull LibraryReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return this.kClass.isInstance((Object)reference.getInfo());
    }

    @Override
    @Nullable
    public LibraryDefinition resolve(@NotNull LibraryReference reference, @NotNull List<Variable> arguments) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        if (!this.accepts(reference)) {
            return null;
        }
        Pair pair2 = (Pair)this.resolveRaw.invoke(KClasses.cast(this.kClass, (Object)reference.getInfo()), (Object)reference.getName());
        String text2 = (String)pair2.component1();
        LibraryDescriptorGlobalOptions options2 = (LibraryDescriptorGlobalOptions)pair2.component2();
        if (text2 == null) {
            return null;
        }
        return ParsingKt.parseLibraryDescriptor(text2).convertToDefinition(arguments, options2);
    }
}

