/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.linearref.LinearGeometryBuilder;
import org.locationtech.jts.linearref.LinearIterator;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.util.Assert;

class ExtractLineByLocation {
    private Geometry line;

    public static Geometry extract(Geometry line, LinearLocation start2, LinearLocation end) {
        ExtractLineByLocation ls = new ExtractLineByLocation(line);
        return ls.extract(start2, end);
    }

    public ExtractLineByLocation(Geometry line) {
        this.line = line;
    }

    public Geometry extract(LinearLocation start2, LinearLocation end) {
        if (end.compareTo(start2) < 0) {
            return this.reverse(this.computeLinear(end, start2));
        }
        return this.computeLinear(start2, end);
    }

    private Geometry reverse(Geometry linear) {
        if (linear instanceof Lineal) {
            return linear.reverse();
        }
        Assert.shouldNeverReachHere("non-linear geometry encountered");
        return null;
    }

    private LineString computeLine(LinearLocation start2, LinearLocation end) {
        Coordinate[] newCoordinateArray;
        Coordinate[] coordinates = this.line.getCoordinates();
        CoordinateList newCoordinates = new CoordinateList();
        int startSegmentIndex = start2.getSegmentIndex();
        if (start2.getSegmentFraction() > 0.0) {
            ++startSegmentIndex;
        }
        int lastSegmentIndex = end.getSegmentIndex();
        if (end.getSegmentFraction() == 1.0) {
            ++lastSegmentIndex;
        }
        if (lastSegmentIndex >= coordinates.length) {
            lastSegmentIndex = coordinates.length - 1;
        }
        if (!start2.isVertex()) {
            newCoordinates.add(start2.getCoordinate(this.line));
        }
        for (int i2 = startSegmentIndex; i2 <= lastSegmentIndex; ++i2) {
            newCoordinates.add(coordinates[i2]);
        }
        if (!end.isVertex()) {
            newCoordinates.add(end.getCoordinate(this.line));
        }
        if (newCoordinates.size() <= 0) {
            newCoordinates.add(start2.getCoordinate(this.line));
        }
        if ((newCoordinateArray = newCoordinates.toCoordinateArray()).length <= 1) {
            newCoordinateArray = new Coordinate[]{newCoordinateArray[0], newCoordinateArray[0]};
        }
        return this.line.getFactory().createLineString(newCoordinateArray);
    }

    private Geometry computeLinear(LinearLocation start2, LinearLocation end) {
        LinearGeometryBuilder builder = new LinearGeometryBuilder(this.line.getFactory());
        builder.setFixInvalidLines(true);
        if (!start2.isVertex()) {
            builder.add(start2.getCoordinate(this.line));
        }
        LinearIterator it = new LinearIterator(this.line, start2);
        while (it.hasNext() && end.compareLocationValues(it.getComponentIndex(), it.getVertexIndex(), 0.0) >= 0) {
            Coordinate pt = it.getSegmentStart();
            builder.add(pt);
            if (it.isEndOfLine()) {
                builder.endLine();
            }
            it.next();
        }
        if (!end.isVertex()) {
            builder.add(end.getCoordinate(this.line));
        }
        return builder.getGeometry();
    }
}

