/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.utils;

import com.intellij.ktor.utils.KtorVersionSuffix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/ktor/utils/KtorVersionModel;", "", "major", "", "minor", "bugfix", "suffix", "Lcom/intellij/ktor/utils/KtorVersionSuffix;", "<init>", "(IIILcom/intellij/ktor/utils/KtorVersionSuffix;)V", "getMajor", "()I", "getMinor", "getBugfix", "getSuffix", "()Lcom/intellij/ktor/utils/KtorVersionSuffix;", "baseVersion", "", "getBaseVersion", "()Ljava/lang/String;", "compareTo", "other", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "Companion", "intellij.ktor"})
public final class KtorVersionModel
implements Comparable<KtorVersionModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int bugfix;
    @NotNull
    private final KtorVersionSuffix suffix;

    public KtorVersionModel(int major, int minor, int bugfix, @NotNull KtorVersionSuffix suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.suffix = suffix;
    }

    public /* synthetic */ KtorVersionModel(int n, int n2, int n3, KtorVersionSuffix ktorVersionSuffix, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            ktorVersionSuffix = KtorVersionSuffix.Companion.Release();
        }
        this(n, n2, n3, ktorVersionSuffix);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getBugfix() {
        return this.bugfix;
    }

    @NotNull
    public final KtorVersionSuffix getSuffix() {
        return this.suffix;
    }

    @NotNull
    public final String getBaseVersion() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    @Override
    public int compareTo(@NotNull KtorVersionModel other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Function1[] function1Array = new Function1[]{KtorVersionModel::compareTo$lambda$0, KtorVersionModel::compareTo$lambda$1, KtorVersionModel::compareTo$lambda$2, KtorVersionModel::compareTo$lambda$3};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    @NotNull
    public String toString() {
        return this.getBaseVersion() + (String)(Intrinsics.areEqual((Object)this.suffix, (Object)KtorVersionSuffix.Companion.Release()) ? "" : "-" + this.suffix);
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.bugfix;
    }

    @NotNull
    public final KtorVersionSuffix component4() {
        return this.suffix;
    }

    @NotNull
    public final KtorVersionModel copy(int major, int minor, int bugfix, @NotNull KtorVersionSuffix suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new KtorVersionModel(major, minor, bugfix, suffix);
    }

    public static /* synthetic */ KtorVersionModel copy$default(KtorVersionModel ktorVersionModel, int n, int n2, int n3, KtorVersionSuffix ktorVersionSuffix, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = ktorVersionModel.major;
        }
        if ((n4 & 2) != 0) {
            n2 = ktorVersionModel.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = ktorVersionModel.bugfix;
        }
        if ((n4 & 8) != 0) {
            ktorVersionSuffix = ktorVersionModel.suffix;
        }
        return ktorVersionModel.copy(n, n2, n3, ktorVersionSuffix);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.bugfix);
        result = result * 31 + this.suffix.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KtorVersionModel)) {
            return false;
        }
        KtorVersionModel ktorVersionModel = (KtorVersionModel)other;
        if (this.major != ktorVersionModel.major) {
            return false;
        }
        if (this.minor != ktorVersionModel.minor) {
            return false;
        }
        if (this.bugfix != ktorVersionModel.bugfix) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.suffix, (Object)ktorVersionModel.suffix);
    }

    private static final Comparable compareTo$lambda$0(KtorVersionModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.major);
    }

    private static final Comparable compareTo$lambda$1(KtorVersionModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.minor);
    }

    private static final Comparable compareTo$lambda$2(KtorVersionModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.bugfix);
    }

    private static final Comparable compareTo$lambda$3(KtorVersionModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.suffix;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ktor/utils/KtorVersionModel$Companion;", "", "<init>", "()V", "parseVersion", "Lcom/intellij/ktor/utils/KtorVersionModel;", "version", "", "allowSuffix", "", "intellij.ktor"})
    @SourceDebugExtension(value={"SMAP\nKtorVersionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorVersionModel.kt\ncom/intellij/ktor/utils/KtorVersionModel$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1#2:86\n1617#3,9:76\n1869#3:85\n1870#3:87\n1626#3:88\n*S KotlinDebug\n*F\n+ 1 KtorVersionModel.kt\ncom/intellij/ktor/utils/KtorVersionModel$Companion\n*L\n21#1:86\n21#1:76,9\n21#1:85\n21#1:87\n21#1:88\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final KtorVersionModel parseVersion(@NotNull String version, boolean allowSuffix) {
            KtorVersionSuffix ktorVersionSuffix;
            List $this$mapNotNull$iv;
            Object parts;
            block9: {
                block8: {
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                    Object object = new char[]{'-'};
                    Object it = object = (Object)StringsKt.split$default((CharSequence)version, (char[])object, (boolean)false, (int)2, (int)2, null);
                    boolean bl = false;
                    Object object2 = it.size() == 1 || it.size() == 2 && allowSuffix ? object : null;
                    if (object2 == null) {
                        return null;
                    }
                    parts = object2;
                    it = new char[1];
                    it[0] = 46;
                    Object it2 = it = (Object)StringsKt.split$default((CharSequence)((CharSequence)parts.get(0)), (char[])it, (boolean)false, (int)0, (int)6, null);
                    boolean bl2 = false;
                    object = it2.size() == 3 ? it : null;
                    Object object3 = object;
                    if (object == null) break block8;
                    it2 = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    void var9_13 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Integer it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl3 = false;
                        String it3 = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (StringsKt.toIntOrNull((String)it3) == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List it4 = $i$f$mapNotNull = (List)destination$iv$iv;
                    boolean bl6 = false;
                    List list = $this$mapNotNull$iv = it4.size() == 3 ? $i$f$mapNotNull : null;
                    if ($this$mapNotNull$iv != null) break block9;
                }
                return null;
            }
            List list = $this$mapNotNull$iv;
            int major = ((Number)list.get(0)).intValue();
            int minor = ((Number)list.get(1)).intValue();
            int bugfix = ((Number)list.get(2)).intValue();
            if (parts.size() == 1) {
                ktorVersionSuffix = KtorVersionSuffix.Companion.Release();
            } else {
                ktorVersionSuffix = KtorVersionSuffix.Companion.parseSuffix((String)parts.get(1));
                if (ktorVersionSuffix == null) {
                    ktorVersionSuffix = KtorVersionSuffix.Companion.Custom();
                }
            }
            KtorVersionSuffix suffix = ktorVersionSuffix;
            return new KtorVersionModel(major, minor, bugfix, suffix);
        }

        public static /* synthetic */ KtorVersionModel parseVersion$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.parseVersion(string, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

