/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigFields;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.PerforceLocalConnection;

public class P4ParamsCalculator {
    private static final String ourInConfig = "(config";
    private static final String ourNoConfig = "'noconfig'";
    private static final String ourInEnvironment = "(set";
    private static final String ourInEnvironment2 = "(env";
    private static final Logger LOG = Logger.getInstance(P4ParamsCalculator.class);
    private final Project myProject;

    public P4ParamsCalculator(Project project) {
        this.myProject = project;
    }

    public P4ConnectionParameters runSetOnFile(PerforcePhysicalConnectionParametersI settings, P4ConnectionParameters defaultParameters, String file) {
        P4ConnectionParameters parameters = new P4ConnectionParameters();
        ExecResult retVal = new ExecResult();
        if (!this.runSetImpl(settings, file, parameters, retVal)) {
            return parameters;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("p4 set output: " + String.valueOf(retVal));
        }
        P4ParamsCalculator.parseSetOutput(defaultParameters, parameters, retVal.getStdout());
        return parameters;
    }

    private boolean runSetImpl(PerforcePhysicalConnectionParametersI settings, String file, P4ConnectionParameters parameters, ExecResult retVal) {
        PerforceLocalConnection localConnection = new PerforceLocalConnection(file);
        try {
            localConnection.runP4Command(settings, new String[]{"set"}, retVal, null);
        }
        catch (VcsException | IOException | InterruptedException | PerforceTimeoutException e) {
            parameters.setException(e);
            return false;
        }
        try {
            PerforceRunner.checkError(retVal, new PerforceSettings(this.myProject), localConnection);
        }
        catch (VcsException e) {
            parameters.setException(e);
            return false;
        }
        return true;
    }

    public static void parseSetOutput(P4ConnectionParameters defaultParameters, P4ConnectionParameters parameters, String output) {
        Map<String, P4ConfigFields> fields = P4ParamsCalculator.p4FieldsAsMap();
        for (String line : StringUtil.splitByLines((String)output)) {
            int noConfigIdx;
            int valueEnd;
            String value;
            String key;
            P4ConfigFields fieldType;
            int eqIdx = line.indexOf("=");
            if (eqIdx == -1 || (fieldType = fields.get(StringUtil.toLowerCase((String)(key = line.substring(0, eqIdx))))) == null) continue;
            int configIdx = line.indexOf(ourInConfig, eqIdx + 1);
            int envIdx = line.indexOf(ourInEnvironment, eqIdx + 1);
            if (envIdx < 0) {
                envIdx = line.indexOf(ourInEnvironment2, eqIdx + 1);
            }
            if ((value = line.substring(eqIdx + 1, valueEnd = envIdx > 0 ? envIdx : (configIdx > 0 ? configIdx : line.length())).trim()).isEmpty()) continue;
            P4ParamsCalculator.setField(fieldType, value, parameters);
            if (configIdx >= 0 && (noConfigIdx = line.indexOf(ourNoConfig, configIdx)) < 0) continue;
            P4ParamsCalculator.setField(fieldType, value, defaultParameters);
        }
    }

    public static P4ConnectionParameters getParametersFromConfig(File configParentDir, @NotNull String name) {
        if (name == null) {
            P4ParamsCalculator.$$$reportNull$$$0(0);
        }
        P4ConnectionParameters parameters = new P4ConnectionParameters();
        JBIterable allConfigs = JBIterable.generate((Object)configParentDir, File::getParentFile).map(dir -> new File((File)dir, name)).filter(File::exists);
        try {
            for (File ioFile : ContainerUtil.reverse((List)allConfigs.toList())) {
                String data = String.valueOf(FileUtil.loadFileText((File)ioFile));
                Map<String, P4ConfigFields> fields = P4ParamsCalculator.p4FieldsAsMap();
                for (String line : StringUtil.splitByLines((String)data)) {
                    ArrayList split = Lists.newArrayList((Iterable)Splitter.on((char)'=').limit(2).trimResults().split((CharSequence)line));
                    if (split.size() != 2) continue;
                    String key = (String)split.get(0);
                    P4ConfigFields p4ConfigField = fields.get(StringUtil.toLowerCase((String)key));
                    P4ParamsCalculator.setField(p4ConfigField, (String)split.get(1), parameters);
                }
            }
        }
        catch (IOException e) {
            parameters.setException(e);
        }
        return parameters;
    }

    private static Map<String, P4ConfigFields> p4FieldsAsMap() {
        P4ConfigFields[] p4ConfigFields = P4ConfigFields.values();
        HashMap<String, P4ConfigFields> fields = new HashMap<String, P4ConfigFields>();
        for (P4ConfigFields configField : p4ConfigFields) {
            fields.put(StringUtil.toLowerCase((String)configField.getName()), configField);
        }
        return fields;
    }

    private static void setField(P4ConfigFields fieldType, String value, P4ConnectionParameters parameters) {
        if (P4ConfigFields.P4CLIENT.equals((Object)fieldType)) {
            parameters.setClient(value);
        } else if (P4ConfigFields.P4PASSWD.equals((Object)fieldType)) {
            parameters.setPassword(value);
        } else if (P4ConfigFields.P4PORT.equals((Object)fieldType)) {
            parameters.setServer(value);
        } else if (P4ConfigFields.P4USER.equals((Object)fieldType)) {
            parameters.setUser(value);
        } else if (P4ConfigFields.P4CHARSET.equals((Object)fieldType)) {
            parameters.setCharset(value);
        } else if (P4ConfigFields.P4CONFIG.equals((Object)fieldType)) {
            parameters.setConfigFileName(value);
        } else if (P4ConfigFields.P4IGNORE.equals((Object)fieldType)) {
            parameters.setIgnoreFileName(value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/perforce/perforce/connections/P4ParamsCalculator", "getParametersFromConfig"));
    }
}

