/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.text;

import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.TextRange;
import ai.grazie.utils.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\r\u001a\u00020\u0007J?\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072*\u0010\u0011\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00130\u0012\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/grazie/text/TextTemplate;", "", "<init>", "()V", "VARIABLE", "Lkotlin/text/Regex;", "unwrap", "", "variable", "name", "findVariablesRangesAt", "", "Lai/grazie/text/TextRange;", "template", "findVariables", "", "render", "vars", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "", "model-text"})
@SourceDebugExtension(value={"SMAP\nTextTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextTemplate.kt\nai/grazie/text/TextTemplate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1557#2:56\n1628#2,3:57\n1062#2:60\n*S KotlinDebug\n*F\n+ 1 TextTemplate.kt\nai/grazie/text/TextTemplate\n*L\n39#1:56\n39#1:57,3\n45#1:60\n*E\n"})
public final class TextTemplate {
    @NotNull
    public static final TextTemplate INSTANCE = new TextTemplate();
    @NotNull
    private static final Regex VARIABLE = new Regex("\u2623\\$\\{\\w+\\}\u2623");

    private TextTemplate() {
    }

    private final String unwrap(String variable) {
        return TextKt.dropPostfix(TextKt.dropPrefix(variable, "\u2623${"), "}\u2623");
    }

    @NotNull
    public final String variable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "\u2623${" + name + "}\u2623";
    }

    @NotNull
    public final List<TextRange> findVariablesRangesAt(@NotNull String template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)VARIABLE, (CharSequence)template, (int)0, (int)2, null), TextTemplate::findVariablesRangesAt$lambda$0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> findVariables(@NotNull String template) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Iterable $this$map$iv = this.findVariablesRangesAt(template);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.unwrap(it.substring(template)));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final String render(@NotNull String template, Pair<String, String> ... vars) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        return this.render(template, MapsKt.toMap((Iterable)ArraysKt.toList((Object[])vars)));
    }

    @NotNull
    public final String render(@NotNull String template, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        Iterable $this$sortedByDescending$iv = this.findVariablesRangesAt(template);
        boolean $i$f$sortedByDescending = false;
        List ranges = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (TextRange)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        });
        String result2 = template;
        for (TextRange range : ranges) {
            String value;
            String variable = this.unwrap(ExtensionsKt.substring(result2, range));
            if (vars.get(variable) == null) {
                throw new IllegalStateException(("Unexpected situation, was unable to find variable '" + variable + "' in provided map").toString());
            }
            result2 = ExtensionsKt.replace(result2, range, value);
        }
        return result2;
    }

    private static final TextRange findVariablesRangesAt$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TextRange.Companion.invoke(it.getRange());
    }
}

