/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lai/grazie/utils/Zip;", "", "<init>", "()V", "unzip", "", "zipPath", "Ljava/nio/file/Path;", "outputDirectory", "utils-common"})
public final class Zip {
    @NotNull
    public static final Zip INSTANCE = new Zip();

    private Zip() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unzip(@NotNull Path zipPath, @NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Closeable closeable = new ZipFile(zipPath.toFile());
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                Long l;
                Comparable comparable;
                ZipEntry entry2 = (ZipEntry)iterator.next();
                String string = entry2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!(!Zip.unzip$isUnsafeZipEntryName(string))) {
                    boolean bl2 = false;
                    String string2 = "'" + entry2.getName() + "' is not a safe zip entry name.";
                    throw new IllegalArgumentException(string2.toString());
                }
                Path entryPath = outputDirectory.resolve(entry2.getName());
                if (entry2.isDirectory()) {
                    Intrinsics.checkNotNull((Object)entryPath);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(entryPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                        Path path = Files.createDirectories(entryPath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
                        comparable = path;
                        continue;
                    }
                }
                Path path = entryPath.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                Object object = path;
                Object object2 = new LinkOption[]{};
                if (!Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
                    Path path2 = entryPath.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
                    object = path2;
                    object2 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, (FileAttribute[])Arrays.copyOf(object2, ((Object[])object2).length)), (String)"createDirectories(...)");
                }
                object = zip.getInputStream(entry2);
                object2 = null;
                try {
                    long l2;
                    InputStream input = (InputStream)object;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)entryPath);
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    OutputStream outputStream = Files.newOutputStream(entryPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    Closeable closeable2 = outputStream;
                    Throwable throwable2 = null;
                    try {
                        OutputStream output = (OutputStream)closeable2;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)input);
                        l2 = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    l = l2;
                }
                catch (Throwable throwable4) {
                    object2 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                comparable = l;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean unzip$isUnsafeZipEntryName(String name) {
        if (StringsKt.isBlank((CharSequence)name)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"/", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)name, (String)"\\", (boolean)false, (int)2, null)) return true;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"..", (boolean)false, (int)2, null)) return true;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)":", (boolean)false, (int)2, null)) return false;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"windows", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

