/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inlay;

import com.intellij.codeInsight.hints.declarative.EndOfLinePosition;
import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.OwnBypassCollector;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/dom/inlay/MavenModelVersionInlayHintCollector;", "Lcom/intellij/codeInsight/hints/declarative/OwnBypassCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "collectHintsForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "intellij.maven"})
public final class MavenModelVersionInlayHintCollector
implements OwnBypassCollector {
    @NotNull
    private final Editor editor;

    public MavenModelVersionInlayHintCollector(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public void collectHintsForFile(@NotNull PsiFile file2, @NotNull InlayTreeSink sink) {
        VirtualFile vFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!(file2 instanceof XmlFile)) {
            return;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(((XmlFile)file2).getProject());
        if (manager.findProject(vFile = ((XmlFile)file2).getVirtualFile()) == null) {
            return;
        }
        XmlTag xmlTag = ((XmlFile)file2).getRootTag();
        if (xmlTag == null || (xmlTag = xmlTag.findFirstSubTag("modelVersion")) == null) {
            return;
        }
        XmlTag modelTag = xmlTag;
        int line = this.editor.getDocument().getLineNumber(modelTag.getTextOffset());
        String string = MavenDomUtil.getXmlProjectModelVersion(file2);
        if (string == null) {
            return;
        }
        String modelVersion = string;
        if (Intrinsics.areEqual((Object)modelVersion, (Object)"4.0.0")) {
            InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new EndOfLinePosition(line, 0, 2, null)), null, null, (HintFormat)HintFormat.Companion.getDefault(), MavenModelVersionInlayHintCollector::collectHintsForFile$lambda$0, (int)6, null);
        } else if (Intrinsics.areEqual((Object)modelVersion, (Object)"4.1.0")) {
            InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new EndOfLinePosition(line, 0, 2, null)), null, null, (HintFormat)HintFormat.Companion.getDefault(), MavenModelVersionInlayHintCollector::collectHintsForFile$lambda$1, (int)6, null);
        }
    }

    private static final Unit collectHintsForFile$lambda$0(PresentationTreeBuilder $this$addPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
        String string = MavenDomBundle.message("maven.version.inlay.hint.text.3", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)string, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectHintsForFile$lambda$1(PresentationTreeBuilder $this$addPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
        String string = MavenDomBundle.message("maven.version.inlay.hint.text.4", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)string, null, (int)2, null);
        return Unit.INSTANCE;
    }
}

