/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage;

import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeOptionsSupport;

public final class RuntimeOptions {
    private RuntimeOptions() {
    }

    public static void set(String optionName, Object value) {
        ImageSingletons.lookup(RuntimeOptionsSupport.class).set(optionName, value);
    }

    public static <T> T get(String optionName) {
        return ImageSingletons.lookup(RuntimeOptionsSupport.class).get(optionName);
    }

    public static List<Descriptor> listDescriptors() {
        return ImageSingletons.lookup(RuntimeOptionsSupport.class).listDescriptors();
    }

    public static Descriptor getDescriptor(String optionName) {
        return ImageSingletons.lookup(RuntimeOptionsSupport.class).getDescriptor(optionName);
    }

    public static interface Descriptor {
        public String name();

        public String help();

        public boolean deprecated();

        public String deprecatedMessage();

        public Class<?> valueType();

        public Object defaultValue();

        public Object convertValue(String var1) throws IllegalArgumentException;
    }
}

