/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerRunConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.RunConfigurationExtender;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationOptions;
import com.intellij.spring.boot.run.SpringBootCommandLineState;
import com.intellij.spring.boot.run.SpringBootConfigurationExtenderProducer;
import com.intellij.spring.boot.run.SpringBootMainClassInfoProvider;
import com.intellij.spring.boot.run.SpringBootRunSharedBundle;
import com.intellij.spring.runtime.SpringRuntimeResourceContext;
import com.intellij.spring.runtime.SpringRuntimeResourceContextBase;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

public final class SpringBootApplicationRunConfiguration
extends ApplicationConfiguration
implements SpringBootApplicationRunConfigurationBase,
ScheduledDebuggerRunConfiguration {
    public static final String DEBUG_PARAMETER = "-Ddebug";
    public static final String TIERED_STOP_AT_LEVEL_1_PARAMETER = "-XX:TieredStopAtLevel=1";
    public static final String NO_VERIFY_PARAMETER = "-noverify";
    static final String HIDE_BANNER_PARAMETER = "-Dspring.main.show_banner=false";
    public static final String HIDE_BANNER_PARAMETER_1_5 = "-Dspring.main.banner-mode=OFF";
    public static final String ACTIVE_PROFILES_PARAMETER = "-Dspring.profiles.active";
    public static final String TRIGGER_FILE_PARAMETER = "-Dspring.devtools.restart.trigger-file";
    public static final String OUTPUT_ANSI_ENABLED_PARAMETER = "-Dspring.output.ansi.enabled=always";

    public SpringBootApplicationRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(name, project, factory);
    }

    @NotNull
    public RunConfigurationExtender getExtender() {
        RunConfigurationExtender runConfigurationExtender = SpringBootConfigurationExtenderProducer.Companion.getAnyExtender(this);
        if (runConfigurationExtender == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(0);
        }
        return runConfigurationExtender;
    }

    @Nullable
    public <E extends RunConfigurationExtender> E getExtenderOfType(@NotNull Class<E> extenderClass) {
        if (extenderClass == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(1);
        }
        return SpringBootConfigurationExtenderProducer.Companion.getExtenderOrNull(this, extenderClass);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.getSpringBootMainClass());
    }

    public String suggestedName() {
        String mainClass = this.getOptions().getSpringBootMainClass();
        if (mainClass == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)mainClass);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor<? extends RunConfiguration> settingsEditor = this.getExtender().getConfigurationEditor();
        if (settingsEditor == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        ((JavaRunConfigurationModule)this.getConfigurationModule()).checkForWarning();
        this.checkClass();
        if (TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)this, (Project)this.getProject()) == null) {
            JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)this.getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
        this.checkAdditionalParams();
        this.getExtender().checkConfiguration();
        this.validateRunTarget(this.getProject());
    }

    @NotNull
    public JavaRunConfigurationModule checkClass() throws RuntimeConfigurationException {
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass mainClass = configurationModule.checkClassName(this.getOptions().getSpringBootMainClass(), SpringBootRunSharedBundle.message("spring.boot.application.run.configuration.class.not.specified", new Object[0]));
        if (!SpringBootMainClassInfoProvider.Companion.getInstance().hasMainMethod(mainClass)) {
            throw new RuntimeConfigurationException(ExecutionBundle.message((String)"main.method.not.found.in.class.error.message", (Object[])new Object[]{this.getOptions().getSpringBootMainClass()}));
        }
        if (!SpringBootMainClassInfoProvider.Companion.getInstance().isSpringBootApplicationRun(mainClass)) {
            throw new RuntimeConfigurationException(SpringBootRunSharedBundle.message("spring.boot.application.run.configuration.invalid.class", new Object[0]));
        }
        JavaRunConfigurationModule javaRunConfigurationModule = configurationModule;
        if (javaRunConfigurationModule == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(3);
        }
        return javaRunConfigurationModule;
    }

    public void checkAdditionalParams() throws RuntimeConfigurationException {
        List<SpringBootAdditionalParameter> parameters = this.getOptions().getAdditionalParameter();
        for (int i = 0; i < parameters.size(); ++i) {
            SpringBootAdditionalParameter parameter = parameters.get(i);
            if (!StringUtil.isEmptyOrSpaces((String)parameter.getName())) continue;
            int index = i;
            throw new RuntimeConfigurationError(SpringBootRunSharedBundle.message("spring.boot.application.run.configuration.invalid.parameter", i + 1), () -> parameters.remove(index));
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(5);
        }
        SpringBootCommandLineState state = new SpringBootCommandLineState(this, environment);
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module.getSearchScope()));
        return state;
    }

    public RunConfigurationTaskState getRunConfigurationTaskState(boolean isDelegated, @NotNull Supplier<JavaParameters> javaParametersSupplier) {
        if (javaParametersSupplier == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(6);
        }
        return this.getExtender().getRunConfigurationTaskState(isDelegated, javaParametersSupplier);
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new RefactoringListeners.SingleClassConfigurationAccessor((SingleClassConfiguration)this));
        if (listener != null) {
            return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
        }
        return this.getExtender().getRefactoringElementListener(element);
    }

    public void setMainClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(7);
        }
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(psiClass.getQualifiedName());
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    @Nullable
    public PsiClass getMainClass() {
        PsiClass psiClass = (PsiClass)DumbService.getInstance((Project)this.getProject()).withAlternativeResolveEnabled(() -> ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.getSpringBootMainClass()));
        return SpringBootMainClassInfoProvider.Companion.getInstance().findMainClassCandidate(psiClass);
    }

    public void setMainClassName(String qualifiedName) {
        this.setSpringBootMainClass(qualifiedName);
    }

    @Nullable
    public String getMainClassName() {
        return this.getSpringBootMainClass();
    }

    @Nullable
    public String getRunClass() {
        PsiClass mainClass = this.getMainClass();
        if (mainClass == null && DumbService.isDumb((Project)this.getProject())) {
            mainClass = this.findMainClassByPackage();
        }
        String mainClassName = mainClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)mainClass) : null;
        return mainClassName != null ? mainClassName : this.getSpringBootMainClass();
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.getOptions().setWorkingDirectory(ExternalizablePath.urlValue((String)value));
    }

    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue((String)this.getOptions().getWorkingDirectory());
    }

    public Module getModule() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = ((JavaRunConfigurationModule)this.getConfigurationModule()).getSearchScope();
        if (globalSearchScope == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    public void setSpringBootMainClass(String springBootMainClass) {
        this.getOptions().setSpringBootMainClass(springBootMainClass);
    }

    public String getSpringBootMainClass() {
        return this.getOptions().getSpringBootMainClass();
    }

    public boolean isDebugMode() {
        return this.getOptions().getDebugMode();
    }

    public void setDebugMode(boolean value) {
        this.getOptions().setDebugMode(value);
    }

    public boolean isEnableLaunchOptimization() {
        return this.getOptions().getEnableLaunchOptimization();
    }

    public void setEnableLaunchOptimization(boolean value) {
        this.getOptions().setEnableLaunchOptimization(value);
    }

    public boolean isHideBanner() {
        return this.getOptions().getHideBanner();
    }

    public void setHideBanner(boolean value) {
        this.getOptions().setHideBanner(value);
    }

    public void setEnableScheduledDebugger(boolean value) {
        this.getOptions().setEnableScheduledDebugger(value);
    }

    public boolean isEnableScheduledDebugger() {
        return this.getOptions().getEnableScheduledDebugger();
    }

    public boolean containsModule(@NotNull Module module) {
        if (module == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(9);
        }
        return this.getModule() == module;
    }

    public List<SpringBootAdditionalParameter> getAdditionalParameters() {
        return this.getOptions().getAdditionalParameter();
    }

    public void setAdditionalParameters(List<SpringBootAdditionalParameter> values) {
        ArrayList<SpringBootAdditionalParameter> copy = new ArrayList<SpringBootAdditionalParameter>();
        for (SpringBootAdditionalParameter value : values) {
            copy.add(new SpringBootAdditionalParameter(value.getEnabled(), value.getName(), value.getValue()));
        }
        this.getOptions().setAdditionalParameter(copy);
    }

    public String getActiveProfiles() {
        return this.getOptions().getActiveProfiles();
    }

    public void setActiveProfiles(String value) {
        this.getOptions().setActiveProfiles(value);
    }

    public String getUrlPath() {
        return this.getOptions().getUrlPath();
    }

    public void setUrlPath(String value) {
        this.getOptions().setUrlPath(value);
    }

    @Nullable
    public ShortenCommandLine getShortenCommandLine() {
        return this.getOptions().getShortenCommandLine();
    }

    public void setShortenCommandLine(@Nullable ShortenCommandLine mode) {
        this.getOptions().setShortenCommandLine(mode);
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
        this.getExtender().createAdditionalTabComponents(manager, startedProcess);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    public void setDefaultFrameDeactivationUpdatePolicy() {
        this.getExtender().setDefaultFrameDeactivationUpdatePolicy();
    }

    @NotNull
    public ClassLoader getResourceClassLoader() {
        ClassLoader classLoader = SpringBootRunSharedBundle.class.getClassLoader();
        if (classLoader == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(10);
        }
        return classLoader;
    }

    @NotNull
    protected SpringBootApplicationRunConfigurationOptions getOptions() {
        SpringBootApplicationRunConfigurationOptions springBootApplicationRunConfigurationOptions = (SpringBootApplicationRunConfigurationOptions)super.getOptions();
        if (springBootApplicationRunConfigurationOptions == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(11);
        }
        return springBootApplicationRunConfigurationOptions;
    }

    private void applySpringBootSettings(JavaParameters params) {
        ParametersList vmParametersList = params.getVMParametersList();
        for (SpringBootAdditionalParameter parameter : this.getAdditionalParameters()) {
            if (!parameter.getEnabled()) continue;
            String parameterValue = parameter.getValue();
            if (StringUtil.isNotEmpty((String)parameterValue)) {
                vmParametersList.add("-D" + parameter.getName() + "=" + parameterValue);
                continue;
            }
            vmParametersList.add("-D" + parameter.getName());
        }
        if (this.isDebugMode()) {
            vmParametersList.add(DEBUG_PARAMETER);
        }
        if (this.isEnableLaunchOptimization()) {
            vmParametersList.add(TIERED_STOP_AT_LEVEL_1_PARAMETER);
            if (!JavaSdkUtil.isJdkAtLeast((Sdk)params.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_13)) {
                vmParametersList.add(NO_VERIFY_PARAMETER);
            }
        }
        if (this.isHideBanner()) {
            boolean isAtLeast15 = (Boolean)ReadAction.compute(() -> SpringBootLibraryUtil.isAtLeastVersion((Module)this.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0));
            if (isAtLeast15) {
                vmParametersList.add(HIDE_BANNER_PARAMETER_1_5);
            } else {
                vmParametersList.add(HIDE_BANNER_PARAMETER);
            }
        }
        if (StringUtil.isNotEmpty((String)this.getActiveProfiles())) {
            vmParametersList.add("-Dspring.profiles.active=" + this.getActiveProfiles());
        }
        vmParametersList.add(OUTPUT_ANSI_ENABLED_PARAMETER);
    }

    @NotNull
    public JavaParameters applyJavaParamsFromConfiguration(@NotNull JavaParameters params) {
        if (params == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(12);
        }
        this.applySpringBootSettings(params);
        this.getExtender().applyAdditionalSpringBootSettings(params);
        JavaParameters javaParameters = params;
        if (javaParameters == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(13);
        }
        return javaParameters;
    }

    public List<VMOption> getKnownVMOptions() {
        List baseOptions = super.getKnownVMOptions();
        Module module = this.getModule();
        if (module == null) {
            return baseOptions;
        }
        List<VMOption> additionalOptions = this.getExtender().getAdditionalVMOptions(module);
        return ContainerUtil.concat((List)baseOptions, additionalOptions);
    }

    @NotNull
    public SpringRuntimeResourceContext getResourceContext() {
        Module module;
        Project project = this.getProject();
        String workingDirectory = ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)this, (Project)project, (Module)(module = this.getModule()));
        if (workingDirectory == null) {
            workingDirectory = "";
            Logger.getInstance(SpringBootApplicationRunConfiguration.class).error("Could not get working directory for run configuration. Working directory: " + this.getWorkingDirectory() + " Project: " + project.getName());
        }
        return new SpringRuntimeResourceContextBase(project, module, (PsiElement)this.getMainClass(), this.getSearchScope(), workingDirectory);
    }

    @Nullable
    private PsiClass findMainClassByPackage() {
        if (this.getModule() == null) {
            return null;
        }
        String mainClassName = this.getSpringBootMainClass();
        if (StringUtil.isEmpty((String)mainClassName)) {
            return null;
        }
        PsiPackage psiPackage = this.findPackage(mainClassName);
        if (psiPackage == null) {
            return null;
        }
        GlobalSearchScope searchScope = this.getSearchScope();
        PsiFile[] files = psiPackage.getFiles(searchScope);
        String shortName = mainClassName.substring(psiPackage.getQualifiedName().length() + 1).replace('$', '.');
        List shortNames = StringUtil.split((String)shortName, (String)".");
        for (PsiFile file : files) {
            UFile uFile = (UFile)UastContextKt.toUElement((PsiElement)file, UFile.class);
            if (uFile == null) continue;
            for (UClass uClass : uFile.getClasses()) {
                if (!((String)shortNames.get(0)).equals(uClass.getName())) continue;
                if (shortNames.size() > 1 && (uClass = SpringBootApplicationRunConfiguration.findClass(shortNames.subList(1, shortNames.size()), uClass)) == null) {
                    return null;
                }
                return SpringBootMainClassInfoProvider.Companion.getInstance().findMainClassCandidate(uClass.getJavaPsi());
            }
        }
        return null;
    }

    @Nullable
    private PsiPackage findPackage(@NotNull String className) {
        String packageName;
        if (className == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(14);
        }
        if ((packageName = StringUtil.getPackageName((String)className)).isEmpty()) {
            return null;
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(packageName);
        return psiPackage != null ? psiPackage : this.findPackage(packageName);
    }

    @Nullable
    private static UClass findClass(@NotNull List<String> shortNames, @NotNull UClass parent) {
        UClass uClass;
        if (shortNames == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(15);
        }
        if (parent == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(16);
        }
        if ((uClass = SpringBootApplicationRunConfiguration.findClass(shortNames.get(0), parent)) == null || shortNames.size() == 1) {
            return uClass;
        }
        return SpringBootApplicationRunConfiguration.findClass(shortNames.subList(1, shortNames.size()), uClass);
    }

    @Nullable
    private static UClass findClass(@NotNull String shortName, @NotNull UClass parent) {
        if (shortName == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            SpringBootApplicationRunConfiguration.$$$reportNull$$$0(18);
        }
        try {
            Object[] classes = parent.getInnerClasses();
            return (UClass)ContainerUtil.find((Object[])classes, uClass -> shortName.equals(uClass.getName()));
        }
        catch (IndexNotReadyException e) {
            PsiElement[] children;
            PsiElement sourcePsi = parent.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            if (sourcePsi instanceof PsiClass) {
                return null;
            }
            for (PsiElement child : children = sourcePsi.getChildren()) {
                PsiElement[] grandChildren;
                for (PsiElement grandChild : grandChildren = child.getChildren()) {
                    PsiNamedElement namedElement;
                    if (!(grandChild instanceof PsiNamedElement) || !shortName.equals((namedElement = (PsiNamedElement)grandChild).getName())) continue;
                    return (UClass)UastContextKt.toUElement((PsiElement)grandChild, UClass.class);
                }
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6, 7, 9, 12, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/SpringBootApplicationRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extenderClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParametersSupplier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortNames";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtender";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceClassLoader";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "applyJavaParamsFromConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExtenderOfType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationTaskState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMainClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyJavaParamsFromConfiguration";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 7, 9, 12, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }
}

