/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.SpringBeanNamesConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBeanNamesConverterImpl
extends SpringBeanNamesConverter {
    public String toString(List<String> strings, @NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanNamesConverterImpl.$$$reportNull$$$0(0);
        }
        return StringUtil.join(strings, (String)",");
    }

    public List<String> fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanNamesConverterImpl.$$$reportNull$$$0(1);
        }
        if (s == null) {
            return null;
        }
        return SpringCommonUtils.tokenize((String)s);
    }

    public PsiReference @NotNull [] createReferences(final GenericDomValue<List<String>> genericDomValue, final PsiElement element, final ConvertContext context) {
        List strings = (List)genericDomValue.getValue();
        if (strings != null) {
            ArrayList<1> references = new ArrayList<1>(strings.size());
            for (String string : strings) {
                int offset = element.getText().indexOf(string);
                if (offset < 0) continue;
                references.add(new PsiReferenceBase<PsiElement>(this, element, TextRange.from((int)offset, (int)string.length())){

                    public PsiElement resolve() {
                        DomElement bean = genericDomValue.getParent();
                        return bean instanceof CommonSpringBean ? BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean).getPsiElement() : null;
                    }

                    public boolean isSoft() {
                        return true;
                    }

                    public Object @NotNull [] getVariants() {
                        Object[] objectArray = SpringBeanCoreUtils.suggestBeanNames((CommonSpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)context));
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return objectArray;
                    }

                    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                        if (newElementName == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        SpringBean bean = (SpringBean)genericDomValue.getParent();
                        assert (bean != null);
                        bean.setName(newElementName);
                        return element;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElementName";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getVariants";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "handleElementRename";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1 -> new IllegalArgumentException(string);
                        };
                    }
                });
            }
            PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                SpringBeanNamesConverterImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBeanNamesConverterImpl.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

