/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.extensions.beanValidation;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModelImpl;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringValidationCustomComponentsDiscoverer
extends CustomLocalComponentsDiscoverer {
    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel springModel) {
        Module module;
        if (springModel == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(0);
        }
        if ((module = springModel.getModule()) == null || DumbService.isDumb((Project)module.getProject())) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(1);
            }
            return list;
        }
        HashSet<CommonSpringBean> myValidators = new HashSet<CommonSpringBean>();
        myValidators.addAll(SpringValidationCustomComponentsDiscoverer.getConstraintValidatorBeans(springModel, module, "javax.validation.ConstraintValidator", "javax.validation.ValidatorFactory"));
        myValidators.addAll(SpringValidationCustomComponentsDiscoverer.getConstraintValidatorBeans(springModel, module, "jakarta.validation.ConstraintValidator", "jakarta.validation.ValidatorFactory"));
        HashSet<CommonSpringBean> hashSet = myValidators;
        if (hashSet == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    private static Collection<CommonSpringBean> getConstraintValidatorBeans(@NotNull LocalModel<?> springModel, Module module, String validatorClass, String factoryClass) {
        PsiClass constraintValidator;
        if (springModel == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(3);
        }
        if ((constraintValidator = SpringCommonUtils.findLibraryClass((Module)module, (String)validatorClass)) == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiClass validatorFactory = SpringCommonUtils.findLibraryClass((Module)module, (String)factoryClass);
        if (validatorFactory == null || !SpringValidationCustomComponentsDiscoverer.doesBeanExist(springModel, validatorFactory)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(5);
            }
            return list;
        }
        HashSet<CommonSpringBean> validators = new HashSet<CommonSpringBean>();
        GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module);
        for (PsiClass aClass : ClassInheritorsSearch.search((PsiClass)constraintValidator, (SearchScope)scope, (boolean)true).findAll()) {
            PsiModifierList modifierList;
            if (aClass.isInterface() || (modifierList = aClass.getModifierList()) == null || modifierList.hasModifierProperty("abstract")) continue;
            validators.add((CommonSpringBean)new CustomSpringComponent(aClass));
        }
        HashSet<CommonSpringBean> hashSet = validators;
        if (hashSet == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public static boolean doesBeanExist(@NotNull LocalModel<?> springModel, PsiClass validatorFactory) {
        if (springModel == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(7);
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        SpringModelSearchParameters.BeanClass params = SpringModelSearchParameters.byClass((PsiClass)validatorFactory);
        RecursionManager.doPreventingRecursion(springModel, (boolean)false, () -> {
            if (springModel instanceof LocalXmlModelImpl) {
                ((LocalXmlModelImpl)springModel).processLocalBeansByClass(params, (Processor<? super SpringBeanPointer<?>>)findFirstProcessor, true);
            } else if (springModel instanceof CacheableCommonSpringModel) {
                ((CacheableCommonSpringModel)springModel).processLocalBeansByClass(params, (Processor)findFirstProcessor);
            }
            return null;
        });
        return findFirstProcessor.isFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintValidatorBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponents";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConstraintValidatorBeans";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doesBeanExist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

