/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.stereotype.SpringContextImport;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSpringImport
extends CommonModelElement.PsiBase
implements SpringImport {
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = IMPORT_JAM_ANNOTATION_KEY.subKey("CustomSpringImport", new SemKey[0]);
    public static final SemKey<CustomSpringImport> JAM_KEY = IMPORT_JAM_KEY.subKey("CustomSpringImport", new SemKey[0]);
    public static final SemKey<JamMemberMeta<PsiClass, CustomSpringImport>> META_KEY = IMPORT_META_KEY.subKey("CustomSpringImport", new SemKey[0]);
    protected final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final AnnotationChildLink myAnnotationChildLink;
    private final PsiAnchor myPsiClassAnchor;
    private final NullableLazyValue<SpringContextImport> myDefiningMetaAnnotation;

    public CustomSpringImport(@NotNull String anno, @NotNull PsiClass psiClassAnchor) {
        if (anno == null) {
            CustomSpringImport.$$$reportNull$$$0(0);
        }
        if (psiClassAnchor == null) {
            CustomSpringImport.$$$reportNull$$$0(1);
        }
        this.myDefiningMetaAnnotation = new NullableLazyValue<SpringContextImport>(){

            @Nullable
            protected SpringContextImport compute() {
                PsiClass annotationType;
                PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation((PsiElement)CustomSpringImport.this.getPsiElement(), (String)CustomSpringImport.this.myAnnotationChildLink.getAnnotationQualifiedName(), (String)"org.springframework.context.annotation.Import");
                if (definingMetaAnnotation != null && (annotationType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)definingMetaAnnotation, PsiClass.class, (boolean)true)) != null) {
                    return (SpringContextImport)SpringContextImport.META.getJamElement((PsiModifierListOwner)annotationType);
                }
                return null;
            }
        };
        this.myAnnotationChildLink = new AnnotationChildLink(anno);
        this.myPsiClassAnchor = PsiAnchor.create((PsiElement)psiClassAnchor);
        this.myPsiAnnotation = this.myAnnotationChildLink.createChildRef((PsiElement)this.getPsiElement());
    }

    @Override
    public PsiClass getPsiElement() {
        return (PsiClass)this.myPsiClassAnchor.retrieve();
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    public List<PsiClass> getImportedClasses() {
        SpringAliasFor aliasFor = this.getAliasAttribute("value");
        if (aliasFor != null) {
            return SpringAliasForUtils.getAliasedPsiClasses(this.myPsiAnnotation, (SpringAliasFor)aliasFor);
        }
        ArrayList<PsiClass> imported = new ArrayList<PsiClass>();
        for (SpringContextImport contextImport : CustomSpringImport.getAllImports((PsiAnnotation)this.myPsiAnnotation.getPsiElement())) {
            imported.addAll(contextImport.getImportedClasses());
        }
        return imported;
    }

    @NotNull
    private static Set<SpringContextImport> getAllImports(@Nullable PsiAnnotation psiAnnotation) {
        return CustomSpringImport.getAllImports(psiAnnotation, new ArrayList<PsiAnnotation>());
    }

    @NotNull
    private static Set<SpringContextImport> getAllImports(@Nullable PsiAnnotation psiAnnotation, @NotNull List<PsiAnnotation> processed) {
        if (processed == null) {
            CustomSpringImport.$$$reportNull$$$0(2);
        }
        if (processed.contains(psiAnnotation)) {
            Set<SpringContextImport> set = Collections.emptySet();
            if (set == null) {
                CustomSpringImport.$$$reportNull$$$0(3);
            }
            return set;
        }
        processed.add(psiAnnotation);
        PsiClass aClass = CustomSpringImport.findClass(psiAnnotation);
        if (aClass == null) {
            Set<SpringContextImport> set = Collections.emptySet();
            if (set == null) {
                CustomSpringImport.$$$reportNull$$$0(4);
            }
            return set;
        }
        List elements = SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringImport.IMPORT_JAM_KEY, (PsiElement)aClass);
        HashSet<SpringContextImport> imports = new HashSet<SpringContextImport>();
        for (SpringImport springImport : elements) {
            if (springImport instanceof SpringContextImport) {
                imports.add((SpringContextImport)springImport);
                continue;
            }
            if (!(springImport instanceof CustomSpringImport)) continue;
            imports.addAll(CustomSpringImport.getAllImports(springImport.getAnnotation(), processed));
        }
        HashSet<SpringContextImport> hashSet = imports;
        if (hashSet == null) {
            CustomSpringImport.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Nullable
    private static PsiClass findClass(@Nullable PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            return null;
        }
        String qualifiedName = psiAnnotation.getQualifiedName();
        if (StringUtil.isEmptyOrSpaces((String)qualifiedName)) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)psiAnnotation.getProject()).findClass(qualifiedName, psiAnnotation.getResolveScope());
    }

    private SpringContextImport getDefiningContextConfiguration() {
        return (SpringContextImport)this.myDefiningMetaAnnotation.getValue();
    }

    private SpringAliasFor getAliasAttribute(@NotNull String attrName) {
        if (attrName == null) {
            CustomSpringImport.$$$reportNull$$$0(6);
        }
        return SpringAliasForUtils.findAliasFor((PsiElement)this.getPsiElement(), (String)this.myAnnotationChildLink.getAnnotationQualifiedName(), (String)"org.springframework.test.context.ContextConfiguration", (String)attrName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassAnchor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/stereotype/CustomSpringImport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/stereotype/CustomSpringImport";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllImports";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAliasAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

