/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import java.sql.Connection;
import java.sql.Driver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CouchbaseJdbcHelper
extends JdbcHelperImpl {
    public static final String ARRAY_TYPE = "array";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String DOUBLE_TYPE = "double";
    public static final String FLOAT_TYPE = "float";
    public static final String NULL_TYPE = "null";
    public static final String INTEGER_TYPE = "integer";
    public static final String LONG_TYPE = "long";
    public static final String NUMERIC_TYPE = "numeric";
    public static final String NUMBER_TYPE = "number";
    public static final String OBJECT_TYPE = "object";
    public static final String STRING_TYPE = "string";
    public static final String UNDEFINED_TYPE = "undefined";
    public static final String UNKNOWN_TYPE = "unknown";
    public static final Map<String, Integer> TYPES_MAP = new HashMap<String, Integer>();
    private static final JdbcSettings.SslMode[] SUPPORTED_SSL_MODES = new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE, JdbcSettings.SslMode.VERIFY_FULL};

    public CouchbaseJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("COUCHBASE", version, connection, jdbcClassLoader);
    }

    public CouchbaseJdbcHelper() {
        this(null, null, null);
    }

    private CouchbaseJdbcHelper(@NotNull CouchbaseJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            CouchbaseJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            CouchbaseJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    public boolean hasLazyConnection() {
        return true;
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) {
        if (!JdbcNativeUtil.detectString(product, "Couchbase")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        JdbcNativeUtil.logInfo("release_version: " + productVer);
        return new CouchbaseJdbcHelper(productVer, delegate, jdbcClassLoader);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            CouchbaseJdbcHelper.$$$reportNull$$$0(2);
        }
        return CouchbaseJdbcHelper.classNameContains(driver, "Couchbase");
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @NotNull
    public static String getTypeName(@Nullable Object o) {
        if (o instanceof String) {
            return STRING_TYPE;
        }
        if (o instanceof List) {
            return ARRAY_TYPE;
        }
        if (o instanceof Map) {
            return OBJECT_TYPE;
        }
        if (o instanceof Float) {
            return FLOAT_TYPE;
        }
        if (o instanceof Double) {
            return DOUBLE_TYPE;
        }
        if (o instanceof Integer) {
            return INTEGER_TYPE;
        }
        if (o instanceof Long) {
            return LONG_TYPE;
        }
        if (o instanceof Number) {
            return NUMBER_TYPE;
        }
        if (o instanceof Boolean) {
            return BOOLEAN_TYPE;
        }
        if (o == null) {
            return NULL_TYPE;
        }
        return UNKNOWN_TYPE;
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new CouchbaseJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            CouchbaseJdbcHelper.$$$reportNull$$$0(3);
        }
        return new CouchbaseJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return SUPPORTED_SSL_MODES;
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            CouchbaseJdbcHelper.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            CouchbaseJdbcHelper.$$$reportNull$$$0(5);
        }
        if (sslMode == null) {
            CouchbaseJdbcHelper.$$$reportNull$$$0(6);
        }
        properties.setProperty("sslenabled", "true");
        CouchbaseJdbcHelper.setIfEmpty(properties, "verifyServerCertificate", sslMode == JdbcSettings.SslMode.REQUIRE ? "false" : "true");
    }

    static {
        TYPES_MAP.put(DOUBLE_TYPE, 8);
        TYPES_MAP.put(FLOAT_TYPE, 6);
        TYPES_MAP.put(INTEGER_TYPE, 4);
        TYPES_MAP.put(LONG_TYPE, -5);
        TYPES_MAP.put(STRING_TYPE, 12);
        TYPES_MAP.put(OBJECT_TYPE, 1111);
        TYPES_MAP.put(ARRAY_TYPE, 2003);
        TYPES_MAP.put(BOOLEAN_TYPE, 16);
        TYPES_MAP.put(NULL_TYPE, 0);
        TYPES_MAP.put(NUMBER_TYPE, 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CouchbaseJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

