/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.method;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemProcessingSink;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.problem.ProblemValidationSink;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.processor.method.MethodProcessor;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMethodProcessor
extends AbstractProcessor
implements MethodProcessor {
    AbstractMethodProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    AbstractMethodProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass, @NotNull String equivalentAnnotationClass) {
        if (supportedClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(2);
        }
        if (supportedAnnotationClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(3);
        }
        if (equivalentAnnotationClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(4);
        }
        super(supportedClass, supportedAnnotationClass, equivalentAnnotationClass);
    }

    @Override
    @NotNull
    public List<? super PsiElement> process(@NotNull PsiClass psiClass, @Nullable String nameHint) {
        if (psiClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(5);
        }
        ArrayList result = new ArrayList();
        for (PsiMethod psiMethod : PsiClassUtil.collectClassMethodsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotationByShortNameOnly((PsiModifierListOwner)psiMethod, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation || !this.possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation, psiMethod) || !this.checkAnnotationFQN(psiClass, psiAnnotation, psiMethod) || !this.validate(psiAnnotation, psiMethod, new ProblemProcessingSink())) continue;
            this.processIntern(psiMethod, psiAnnotation, result);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected boolean checkAnnotationFQN(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiMethod psiMethod) {
        if (psiClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(8);
        }
        if (psiMethod == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(9);
        }
        return PsiAnnotationSearchUtil.checkAnnotationHasOneOfFQNs(psiAnnotation, this.getSupportedAnnotationClasses());
    }

    protected boolean possibleToGenerateElementNamed(@Nullable String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiMethod psiMethod) {
        if (psiClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(10);
        }
        if (psiAnnotation == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(11);
        }
        if (psiMethod == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(12);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(13);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (PsiMethod psiMethod : PsiClassUtil.collectClassMethodsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiMethod, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation) continue;
            result.add(psiAnnotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(15);
        }
        Collection<LombokProblem> result = Collections.emptyList();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMethod.class);
        if (null != psiMethod) {
            ProblemValidationSink problemNewBuilder = new ProblemValidationSink();
            this.validate(psiAnnotation, psiMethod, problemNewBuilder);
            result = problemNewBuilder.getProblems();
        }
        List<LombokProblem> list = result;
        if (list == null) {
            AbstractMethodProcessor.$$$reportNull$$$0(16);
        }
        return list;
    }

    protected abstract boolean validate(@NotNull PsiAnnotation var1, @NotNull PsiMethod var2, @NotNull ProblemSink var3);

    protected abstract void processIntern(PsiMethod var1, PsiAnnotation var2, List<? super PsiElement> var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalentAnnotationClass";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/method/AbstractMethodProcessor";
                break;
            }
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/method/AbstractMethodProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationFQN";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 14, 16 -> new IllegalStateException(string);
        };
    }
}

