/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.lineMarkers.renderers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.jetbrains.rd.ide.model.LineMarkerActionEvent;
import com.jetbrains.rd.ide.model.LineMarkerActionModel;
import com.jetbrains.rd.ide.model.StringTooltipModel;
import com.jetbrains.rd.ide.model.TooltipModel;
import com.jetbrains.rdclient.daemon.highlighters.lineMarkers.UtilKt;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipCalculator;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import java.awt.Component;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/lineMarkers/renderers/FrontendLineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "Lcom/intellij/openapi/editor/markup/ActiveGutterRenderer;", "highlighterId", "", "_position", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "actionModel", "Lcom/jetbrains/rd/ide/model/LineMarkerActionModel;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "<init>", "(JLcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;Lcom/jetbrains/rd/ide/model/LineMarkerActionModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;)V", "tooltip", "", "Lorg/jetbrains/annotations/Nls;", "tooltipCalculator", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipCalculator;", "getTooltipText", "getPosition", "canDoAction", "", "e", "Ljava/awt/event/MouseEvent;", "doAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rd.client"})
public abstract class FrontendLineMarkerRenderer
implements LineMarkerRendererEx,
ActiveGutterRenderer {
    private final long highlighterId;
    @NotNull
    private final LineMarkerRendererEx.Position _position;
    @Nullable
    private final LineMarkerActionModel actionModel;
    @Nullable
    private final FrontendTooltipProvider tooltipProvider;
    @Nullable
    private String tooltip;
    @Nullable
    private final FrontendTooltipCalculator tooltipCalculator;

    public FrontendLineMarkerRenderer(long highlighterId, @NotNull LineMarkerRendererEx.Position _position, @Nullable LineMarkerActionModel actionModel, @Nullable FrontendTooltipProvider tooltipProvider) {
        FrontendTooltipCalculator frontendTooltipCalculator;
        Intrinsics.checkNotNullParameter((Object)_position, (String)"_position");
        this.highlighterId = highlighterId;
        this._position = _position;
        this.actionModel = actionModel;
        this.tooltipProvider = tooltipProvider;
        if (this.tooltipProvider != null) {
            long l = this.highlighterId;
            FrontendTooltipProvider frontendTooltipProvider = this.tooltipProvider;
            frontendTooltipCalculator = new FrontendTooltipCalculator(l, frontendTooltipProvider){

                @Override
                public void updateData(TooltipModel tooltipModel) {
                    TooltipModel tooltipModel2 = tooltipModel;
                    if (!(tooltipModel2 == null ? true : tooltipModel2 instanceof StringTooltipModel)) {
                        return;
                    }
                    StringTooltipModel stringTooltipModel = (StringTooltipModel)tooltipModel;
                    tooltip = stringTooltipModel != null ? stringTooltipModel.getText() : null;
                }
            };
        } else {
            frontendTooltipCalculator = null;
        }
        this.tooltipCalculator = frontendTooltipCalculator;
    }

    public /* synthetic */ FrontendLineMarkerRenderer(long l, LineMarkerRendererEx.Position position, LineMarkerActionModel lineMarkerActionModel, FrontendTooltipProvider frontendTooltipProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            position = LineMarkerRendererEx.Position.RIGHT;
        }
        this(l, position, lineMarkerActionModel, frontendTooltipProvider);
    }

    @Nullable
    public String getTooltipText() {
        block0: {
            FrontendTooltipCalculator frontendTooltipCalculator = this.tooltipCalculator;
            if (frontendTooltipCalculator == null) break block0;
            frontendTooltipCalculator.calculateTooltip();
        }
        return this.tooltip;
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return this._position;
    }

    public boolean canDoAction(@NotNull MouseEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.actionModel == null) {
            return false;
        }
        Component component = e.getComponent();
        if (component instanceof EditorGutterComponentEx) {
            if (WhenMappings.$EnumSwitchMapping$0[this.getPosition().ordinal()] == 1) {
                return e.getX() > ((EditorGutterComponentEx)component).getLineMarkerAreaOffset() && e.getX() < ((EditorGutterComponentEx)component).getIconAreaOffset();
            }
            bl = e.getX() >= ((EditorGutterComponentEx)component).getLineMarkerFreePaintersAreaOffset();
        } else {
            bl = false;
        }
        return bl;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.consume();
            LineMarkerActionModel lineMarkerActionModel = this.actionModel;
            if (lineMarkerActionModel == null || (lineMarkerActionModel = lineMarkerActionModel.getClick()) == null) break block0;
            lineMarkerActionModel.fire((Object)new LineMarkerActionEvent(this.highlighterId, UtilKt.toModel(e.getButton())));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineMarkerRendererEx.Position.values().length];
            try {
                nArray[LineMarkerRendererEx.Position.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

