/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaConfigurable;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaPatternComparator;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaMappingsConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA = "settings.json.schema";
    private Runnable myInitializer;
    private static final Comparator<UserDefinedJsonSchemaConfiguration> COMPARATOR = (o1, o2) -> {
        if (o1.isApplicationDefined() != o2.isApplicationDefined()) {
            return o1.isApplicationDefined() ? 1 : -1;
        }
        return o1.getName().compareToIgnoreCase(o2.getName());
    };
    @Nls
    static final String STUB_SCHEMA_NAME = JsonBundle.message((String)"new.schema", (Object[])new Object[0]);
    @Nls
    private String myError;
    @NotNull
    private final Project myProject;
    private final TreeUpdater myTreeUpdater;
    private final Function<String, String> myNameCreator;

    public JsonSchemaMappingsConfigurable(@NotNull Project project) {
        if (project == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(0);
        }
        this.myInitializer = null;
        this.myTreeUpdater = showWarning -> {
            this.TREE_UPDATER.run();
            this.updateWarningText(showWarning);
        };
        this.myNameCreator = s -> this.createUniqueName((String)s);
        this.myProject = project;
        this.initTree();
    }

    @Nullable
    protected String getEmptySelectionString() {
        return this.myRoot.children().hasMoreElements() ? JsonBundle.message((String)"schema.configuration.mapping.empty.area.string", (Object[])new Object[0]) : JsonBundle.message((String)"schema.configuration.mapping.empty.area.alt.string", (Object[])new Object[0]);
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add((AnAction)new DumbAwareAction(JsonBundle.messagePointer((String)"action.DumbAware.JsonSchemaMappingsConfigurable.text.add", (Object[])new Object[0]), JsonBundle.messagePointer((String)"action.DumbAware.JsonSchemaMappingsConfigurable.description.add", (Object[])new Object[0]), IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.getInsert(), (JComponent)JsonSchemaMappingsConfigurable.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JsonSchemaMappingsConfigurable.this.addProjectSchema();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsConfigurable$1", "actionPerformed"));
            }
        });
        result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return result;
    }

    public UserDefinedJsonSchemaConfiguration addProjectSchema() {
        UserDefinedJsonSchemaConfiguration configuration = new UserDefinedJsonSchemaConfiguration(this.createUniqueName(STUB_SCHEMA_NAME), JsonSchemaVersion.SCHEMA_4, "", false, null);
        configuration.setGeneratedName(configuration.getName());
        this.addCreatedMappings(configuration);
        return configuration;
    }

    @NotNull
    @Nls
    private String createUniqueName(@NotNull @NlsSafe String s) {
        if (s == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(1);
        }
        int max = -1;
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            String displayName;
            Object element = children.nextElement();
            if (!(element instanceof MasterDetailsComponent.MyNode) || !(displayName = ((MasterDetailsComponent.MyNode)element).getDisplayName()).startsWith(s)) continue;
            String lastPart = displayName.substring(s.length()).trim();
            if (lastPart.isEmpty() && max == -1) {
                max = 1;
                continue;
            }
            int i = JsonSchemaMappingsConfigurable.tryParseInt(lastPart);
            if (i == -1) continue;
            max = Math.max(i, max);
        }
        Object object = max == -1 ? s : s + " " + (max + 1);
        if (object == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(2);
        }
        return object;
    }

    private static int tryParseInt(@NotNull String s) {
        if (s == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(3);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void addCreatedMappings(@NotNull UserDefinedJsonSchemaConfiguration info) {
        if (info == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(4);
        }
        JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, "", info, this.myTreeUpdater, this.myNameCreator);
        configurable.setError(this.myError, true);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node, true);
    }

    private void fillTree() {
        this.myRoot.removeAllChildren();
        if (this.myProject.isDefault()) {
            return;
        }
        List<UserDefinedJsonSchemaConfiguration> list = this.getStoredList();
        for (UserDefinedJsonSchemaConfiguration info : list) {
            String pathToSchema = info.getRelativePathToSchema();
            JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, JsonFileResolver.isAbsoluteUrl(pathToSchema) || new File(pathToSchema).isAbsolute() ? pathToSchema : new File(this.myProject.getBasePath(), pathToSchema).getPath(), info, this.myTreeUpdater, this.myNameCreator);
            configurable.setError(this.myError, true);
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)configurable));
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        if (this.myRoot.children().hasMoreElements()) {
            this.myTree.addSelectionRow(0);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getStoredList() {
        ArrayList<UserDefinedJsonSchemaConfiguration> list = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Map<String, UserDefinedJsonSchemaConfiguration> projectState = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).getStateMap();
        if (projectState != null) {
            list.addAll(projectState.values());
        }
        list.sort(COMPARATOR);
        ArrayList<UserDefinedJsonSchemaConfiguration> arrayList = list;
        if (arrayList == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void apply() throws ConfigurationException {
        Project[] projects;
        List<UserDefinedJsonSchemaConfiguration> uiList = this.getUiList(true);
        JsonSchemaMappingsConfigurable.validate(uiList);
        HashMap<String, UserDefinedJsonSchemaConfiguration> projectMap = new HashMap<String, UserDefinedJsonSchemaConfiguration>();
        for (UserDefinedJsonSchemaConfiguration info : uiList) {
            projectMap.put(info.getName(), info);
        }
        JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).setState(projectMap);
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            JsonSchemaService service = JsonSchemaService.Impl.get(project);
            if (service == null) continue;
            service.reset();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart((Object)this);
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    private static void validate(@NotNull List<UserDefinedJsonSchemaConfiguration> list) throws ConfigurationException {
        if (list == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(6);
        }
        HashSet<String> set = new HashSet<String>();
        for (UserDefinedJsonSchemaConfiguration info : list) {
            if (set.contains(info.getName())) {
                throw new ConfigurationException(JsonBundle.message((String)"schema.configuration.error.duplicate.name", (Object[])new Object[]{info.getName()}));
            }
            set.add(info.getName());
        }
    }

    public boolean isModified() {
        List<UserDefinedJsonSchemaConfiguration> uiList;
        List<UserDefinedJsonSchemaConfiguration> storedList = this.getStoredList();
        try {
            uiList = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return false;
        }
        return !storedList.equals(uiList);
    }

    private void updateWarningText(boolean showWarning) {
        List<UserDefinedJsonSchemaConfiguration> list;
        MultiMap patternsMap = new MultiMap();
        StringBuilder sb = new StringBuilder();
        try {
            list = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return;
        }
        for (UserDefinedJsonSchemaConfiguration info : list) {
            info.refreshPatterns();
            JsonSchemaPatternComparator comparator = new JsonSchemaPatternComparator(this.myProject);
            List<UserDefinedJsonSchemaConfiguration.Item> patterns = info.getPatterns();
            for (UserDefinedJsonSchemaConfiguration.Item pattern : patterns) {
                for (Map.Entry entry : patternsMap.entrySet()) {
                    for (UserDefinedJsonSchemaConfiguration.Item item : (Collection)entry.getValue()) {
                        ThreeState similar = comparator.isSimilar(pattern, item);
                        if (ThreeState.NO.equals((Object)similar)) continue;
                        if (!sb.isEmpty()) {
                            sb.append('\n');
                        }
                        sb.append(JsonBundle.message((String)"schema.configuration.error.conflicting.mappings.desc", (Object[])new Object[]{pattern.getPresentation(), info.getName(), item.getPresentation(), entry.getKey()}));
                    }
                }
            }
            patternsMap.put((Object)info.getName(), patterns);
        }
        this.myError = !sb.isEmpty() ? JsonBundle.message((String)"schema.configuration.error.conflicting.mappings.title", (Object[])new Object[]{sb.toString()}) : null;
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            Object o = children.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode) || !(((MasterDetailsComponent.MyNode)o).getConfigurable() instanceof JsonSchemaConfigurable)) continue;
            ((JsonSchemaConfigurable)((MasterDetailsComponent.MyNode)o).getConfigurable()).setError(this.myError, showWarning);
        }
    }

    public void selectInTree(UserDefinedJsonSchemaConfiguration configuration) {
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)children.nextElement();
            JsonSchemaConfigurable configurable = (JsonSchemaConfigurable)node.getConfigurable();
            if (!Objects.equals(configurable.getUiSchema(), configuration)) continue;
            this.selectNodeInTree((DefaultMutableTreeNode)node);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getUiList(boolean applyChildren) throws ConfigurationException {
        ArrayList<UserDefinedJsonSchemaConfiguration> uiList = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)children.nextElement();
            if (applyChildren) {
                node.getConfigurable().apply();
                uiList.add(JsonSchemaMappingsConfigurable.getSchemaInfo(node));
                continue;
            }
            uiList.add(((JsonSchemaConfigurable)node.getConfigurable()).getUiSchema());
        }
        uiList.sort(COMPARATOR);
        ArrayList<UserDefinedJsonSchemaConfiguration> arrayList = uiList;
        if (arrayList == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public void setInitializer(@NotNull Runnable initializer) {
        if (initializer == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(8);
        }
        this.myInitializer = initializer;
    }

    public void reset() {
        this.fillTree();
        this.updateWarningText(true);
        if (this.myInitializer != null) {
            this.myInitializer.run();
            this.myInitializer = null;
        }
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return (o1, o2) -> {
            if (o1.getConfigurable() instanceof JsonSchemaConfigurable && o2.getConfigurable() instanceof JsonSchemaConfigurable) {
                return COMPARATOR.compare(JsonSchemaMappingsConfigurable.getSchemaInfo(o1), JsonSchemaMappingsConfigurable.getSchemaInfo(o2));
            }
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        };
    }

    private static UserDefinedJsonSchemaConfiguration getSchemaInfo(@NotNull MasterDetailsComponent.MyNode node) {
        if (node == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(9);
        }
        return ((JsonSchemaConfigurable)node.getConfigurable()).getSchema();
    }

    @Nls
    public String getDisplayName() {
        return JsonBundle.message((String)"configurable.JsonSchemaMappingsConfigurable.display.name", (Object[])new Object[0]);
    }

    public void dispose() {
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            Object o = children.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode)) continue;
            ((MasterDetailsComponent.MyNode)o).getConfigurable().disposeUIResources();
        }
    }

    @NotNull
    public String getId() {
        return SETTINGS_JSON_SCHEMA;
    }

    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueName";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryParseInt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCreatedMappings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7 -> new IllegalStateException(string);
        };
    }
}

