/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.packaging;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.packaging.JpaDescriptorsNodePresentation;
import com.intellij.jpa.packaging.JpaDescriptorsPackagingElementType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaDescriptorsPackagingElement
extends ComplexPackagingElement<JpaDescriptorsPackagingElementState> {
    private FacetPointer<JpaFacet> myFacetPointer;
    private final Project myProject;

    public JpaDescriptorsPackagingElement(Project project, JpaFacet facet) {
        super((PackagingElementType)JpaDescriptorsPackagingElementType.getInstance());
        this.myProject = project;
        this.myFacetPointer = facet != null ? FacetPointersManager.getInstance((Project)project).create((Facet)facet) : null;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        JpaFacet facet;
        if (context == null) {
            JpaDescriptorsPackagingElement.$$$reportNull$$$0(0);
        }
        if (artifactType == null) {
            JpaDescriptorsPackagingElement.$$$reportNull$$$0(1);
        }
        if ((facet = this.getFacet()) != null) {
            ConfigFileMetaData metaData;
            ArrayList<PackagingElement> descriptors = new ArrayList<PackagingElement>();
            ConfigFile mainDd = facet.getMainDeploymentDescriptor();
            ConfigFile defOrmDd = facet.getDefaultORMDescriptor();
            VirtualFile persistenceXml = mainDd != null ? mainDd.getVirtualFile() : null;
            VirtualFile defOrmXml = defOrmDd != null ? defOrmDd.getVirtualFile() : null;
            PackagingElementFactory factory = PackagingElementFactory.getInstance();
            if (persistenceXml != null) {
                metaData = mainDd.getMetaData();
                descriptors.add(factory.createFileCopyWithParentDirectories(persistenceXml.getPath(), metaData.getDirectoryPath(), metaData.getFileName()));
            }
            if (defOrmXml != null) {
                metaData = defOrmDd.getMetaData();
                descriptors.add(factory.createFileCopyWithParentDirectories(defOrmXml.getPath(), metaData.getDirectoryPath(), metaData.getFileName()));
            }
            return descriptors;
        }
        return Collections.emptyList();
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            JpaDescriptorsPackagingElement.$$$reportNull$$$0(2);
        }
        return new DelegatedPackagingElementPresentation((TreeNodePresentation)new JpaDescriptorsNodePresentation(this.myFacetPointer));
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            JpaDescriptorsPackagingElement.$$$reportNull$$$0(3);
        }
        return element instanceof JpaDescriptorsPackagingElement && this.myFacetPointer != null && this.myFacetPointer.equals(((JpaDescriptorsPackagingElement)element).myFacetPointer);
    }

    public JpaDescriptorsPackagingElementState getState() {
        JpaDescriptorsPackagingElementState state = new JpaDescriptorsPackagingElementState();
        state.myFacetPointer = this.myFacetPointer != null ? this.myFacetPointer.getId() : null;
        return state;
    }

    public void loadState(@NotNull JpaDescriptorsPackagingElementState state) {
        String pointer;
        if (state == null) {
            JpaDescriptorsPackagingElement.$$$reportNull$$$0(4);
        }
        this.myFacetPointer = (pointer = state.myFacetPointer) != null ? FacetPointersManager.getInstance((Project)this.myProject).create(pointer) : null;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            JpaDescriptorsPackagingElement.$$$reportNull$$$0(5);
        }
        return packagingElementOutputKind;
    }

    public String toString() {
        return "jpa-resources:" + this.myFacetPointer.getFacetName() + "(" + this.myFacetPointer.getModuleName() + ")";
    }

    @Nullable
    public JpaFacet getFacet() {
        return this.myFacetPointer != null ? (JpaFacet)this.myFacetPointer.getFacet() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/packaging/JpaDescriptorsPackagingElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/packaging/JpaDescriptorsPackagingElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class JpaDescriptorsPackagingElementState {
        @Attribute(value="facet")
        public String myFacetPointer;
    }
}

