/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMapper;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/wsl/WslPathMapper;", "Lcom/intellij/util/PathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/wsl/WSLDistribution;)V", "projectRootWslPathRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/execution/wsl/WslPath;", "isEmpty", "", "canReplaceLocal", "localPath", "", "convertToRemote", "canReplaceRemote", "remotePath", "convertToLocal", "getWindowsUncPathWithProjectWslPrefix", "windowsUncPath", "originalWslRoot", "projectWslRoot", "", "paths", "", "getProjectRootWslPath", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nWslPathMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslPathMapper.kt\ncom/intellij/javascript/nodejs/interpreter/wsl/WslPathMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1563#2:69\n1634#2,3:70\n1#3:73\n*S KotlinDebug\n*F\n+ 1 WslPathMapper.kt\ncom/intellij/javascript/nodejs/interpreter/wsl/WslPathMapper\n*L\n56#1:69\n56#1:70,3\n*E\n"})
public final class WslPathMapper
implements PathMapper {
    @NotNull
    private final Project project;
    @NotNull
    private final WSLDistribution distribution;
    @Nullable
    private Ref<WslPath> projectRootWslPathRef;

    public WslPathMapper(@NotNull Project project, @NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        this.project = project;
        this.distribution = distribution;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean canReplaceLocal(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Path path2 = NioFiles.toPath((String)localPath);
        return path2 != null && this.distribution.getWslPath(path2) != null;
    }

    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        try {
            path2 = Path.of(localPath, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new IllegalStateException("Cannot convert " + localPath, e);
        }
        Path path3 = path2;
        String string = this.distribution.getWslPath(path3);
        if (string == null) {
            throw new IllegalStateException("Cannot convert " + localPath);
        }
        return string;
    }

    public boolean canReplaceRemote(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        return StringsKt.startsWith$default((String)remotePath, (String)"/", (boolean)false, (int)2, null);
    }

    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String string = this.distribution.getWindowsPath(remotePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
        String path2 = string;
        WslPath wslPath = WslPath.Companion.parseWindowsUncPath(path2);
        if (wslPath == null) {
            return path2;
        }
        WslPath wslPath2 = wslPath;
        WslPath wslPath3 = this.getProjectRootWslPath();
        if (wslPath3 == null) {
            return path2;
        }
        WslPath projectRootWslPath = wslPath3;
        if (!Intrinsics.areEqual((Object)wslPath2.getDistributionId(), (Object)projectRootWslPath.getDistributionId())) {
            return path2;
        }
        return this.getWindowsUncPathWithProjectWslPrefix(path2, wslPath2.getWslRoot(), projectRootWslPath.getWslRoot());
    }

    private final String getWindowsUncPathWithProjectWslPrefix(String windowsUncPath, String originalWslRoot, String projectWslRoot) {
        Object object;
        if (!Intrinsics.areEqual((Object)originalWslRoot, (Object)projectWslRoot) && StringsKt.startsWith$default((String)windowsUncPath, (String)originalWslRoot, (boolean)false, (int)2, null)) {
            String string = windowsUncPath.substring(originalWslRoot.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = projectWslRoot + string;
        } else {
            object = windowsUncPath;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> convertToRemote(@NotNull Collection<String> paths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertToRemote((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final WslPath getProjectRootWslPath() {
        Ref result2 = this.projectRootWslPathRef;
        if (result2 == null) {
            WslPath wslPath;
            String projectRootPath;
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
            String string = projectRootPath = virtualFile != null ? virtualFile.getPath() : null;
            if (string != null) {
                String it = string;
                boolean bl = false;
                wslPath = WslPath.Companion.parseWindowsUncPath(projectRootPath);
            } else {
                wslPath = null;
            }
            this.projectRootWslPathRef = result2 = Ref.create(wslPath);
        }
        return (WslPath)result2.get();
    }
}

