/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.remote.JSDownloadRemoteModuleQuickFix;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUrlImportUsageInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUrlImportUsageInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUrlImportUsageInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
                if (importDeclaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitES6ImportDeclaration(importDeclaration);
                if (!StringUtil.isEmpty((String)importDeclaration.getImportModuleText())) {
                    this.checkForUrlImports((PsiElement)importDeclaration);
                } else {
                    this.checkForUrlImports((PsiElement)importDeclaration.getFromClause());
                }
            }

            public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
                if (exportDeclaration == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitES6ExportDeclaration(exportDeclaration);
                this.checkForUrlImports((PsiElement)exportDeclaration.getFromClause());
            }

            public void visitES6ImportCall(@NotNull ES6ImportCall importCall) {
                if (importCall == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitES6ImportCall(importCall);
                this.checkForUrlImports((PsiElement)importCall.getStringArgument());
            }

            private void checkForUrlImports(@Nullable PsiElement element2) {
                if (element2 == null || !DialectDetector.isJavaScript((PsiElement)element2)) {
                    return;
                }
                this.checkForRemoteUrlImport(element2);
            }

            private void checkForRemoteUrlImport(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!holder.isOnTheFly()) {
                    return;
                }
                Pair literalWithText = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)element2);
                if (literalWithText == null) {
                    return;
                }
                String url = JSStringUtil.unquoteStringLiteralValue((String)((String)literalWithText.first));
                if (StringUtil.isEmptyOrSpaces((String)url)) {
                    return;
                }
                PsiElement literal = (PsiElement)literalWithText.second;
                if (JSUrlImportsUtil.isSupportedRemoteModuleUrl((String)url)) {
                    TextRange rangeInElement = TextRange.from((int)(literal.getStartOffsetInParent() + 1), (int)url.length());
                    JSDownloadRemoteModuleQuickFix downloadFix = new JSDownloadRemoteModuleQuickFix(url);
                    holder.registerProblem(element2, JSUrlImportUsageInspection.this.getDisplayName(), ProblemHighlightType.INFORMATION, rangeInElement, new LocalQuickFix[]{downloadFix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exportDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importCall";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSUrlImportUsageInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ExportDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportCall";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkForRemoteUrlImport";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JavaScriptBundle.message((String)"js.url.import.usage.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUrlImportUsageInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSUrlImportUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSUrlImportUsageInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

