/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.thymeleaf;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverFactory;
import com.intellij.spring.mvc.views.ViewResolverUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ThymeleafViewResolverFactory
extends ViewResolverFactory {
    private static final String[] ourResolvers = new String[]{"org.thymeleaf.spring3.view.ThymeleafViewResolver", "org.thymeleaf.spring4.view.ThymeleafViewResolver"};

    ThymeleafViewResolverFactory() {
    }

    @Override
    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(0);
        }
        for (String resolverClass : ourResolvers) {
            if (!((Boolean)ReadAction.compute(() -> InheritanceUtil.isInheritor((PsiClass)beanClass, (String)resolverClass))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getBeanClass() {
        return null;
    }

    @Override
    @NotNull
    public Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        Module module;
        assert (bean != null);
        Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
        if (module == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                ThymeleafViewResolverFactory.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<ViewResolver> resolvers = new HashSet<ViewResolver>();
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        PsiClass templateResolverClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.thymeleaf.templateresolver.ITemplateResolver", moduleScope);
        if (templateResolverClass == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                ThymeleafViewResolverFactory.$$$reportNull$$$0(2);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)templateResolverClass).withInheritors();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (!configurers.isEmpty()) {
            if (bean instanceof SpringBean) {
                resolvers.addAll(this.getTemplateResolvers((SpringBean)bean));
            } else {
                for (SpringBeanPointer templateResolver : configurers) {
                    ViewResolver viewResolver = SpringControllerUtils.createURLBasedViewResolver(module, templateResolver);
                    resolvers.add(viewResolver);
                }
            }
        } else {
            PsiFile file = bean.getContainingFile();
            if (file instanceof PsiJavaFile) {
                resolvers.addAll(ViewResolverUtils.getConfiguredViewResolvers("org.thymeleaf.templateresolver.TemplateResolver", module, (SearchScope)GlobalSearchScope.fileScope((PsiFile)file)));
            }
        }
        HashSet<ViewResolver> hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public Set<ViewResolver> getTemplateResolvers(@NotNull SpringBean bean) {
        CommonSpringBean templateEngine;
        SpringBeanPointer templateEngineBean;
        Module module;
        if (bean == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(4);
        }
        if ((module = bean.getModule()) == null) {
            Set<ViewResolver> set = Set.of();
            if (set == null) {
                ThymeleafViewResolverFactory.$$$reportNull$$$0(5);
            }
            return set;
        }
        HashSet<ViewResolver> resolvers = new HashSet<ViewResolver>();
        SpringPropertyDefinition property = bean.getProperty("templateEngine");
        if (property instanceof SpringProperty && (templateEngineBean = (SpringBeanPointer)((SpringProperty)property).getRefAttr().getValue()) != null && (templateEngine = templateEngineBean.getSpringBean()) instanceof SpringBean) {
            SpringPropertyDefinition templateResolversProperty;
            SpringBeanPointer templateResolver2;
            SpringPropertyDefinition templateResolverProperty = ((SpringBean)templateEngine).getProperty("templateResolver");
            if (templateResolverProperty instanceof SpringProperty && (templateResolver2 = templateResolverProperty.getRefValue()) != null) {
                ViewResolver viewResolver = SpringControllerUtils.createURLBasedViewResolver(module, templateResolver2);
                resolvers.add(viewResolver);
            }
            if ((templateResolversProperty = ((SpringBean)templateEngine).getProperty("templateResolvers")) instanceof SpringProperty) {
                Set<SpringBeanPointer<?>> pointers = ThymeleafViewResolverFactory.getCollectionPointers((SpringProperty)templateResolversProperty);
                StreamEx.of(pointers).map(templateResolver -> SpringControllerUtils.createURLBasedViewResolver(module, templateResolver)).into(resolvers);
            }
        }
        HashSet<ViewResolver> hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> getCollectionPointers(@NotNull SpringProperty springProperty) {
        if (springProperty == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(7);
        }
        LinkedHashMap beans = new LinkedHashMap();
        List listOrSets = DomUtil.getChildrenOfType((DomElement)springProperty, ListOrSet.class);
        for (ListOrSet listOrSet : listOrSets) {
            SpringPropertyUtils.addCollectionReferences((CollectionElements)listOrSet, beans);
        }
        Set<SpringBeanPointer<?>> set = beans.keySet();
        if (set == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/thymeleaf/ThymeleafViewResolverFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/thymeleaf/ThymeleafViewResolverFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateResolvers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateResolvers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionPointers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

