/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.environment;

import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.environment.Environment;
import com.intellij.platform.ml.environment.EnvironmentExtender;
import com.intellij.platform.ml.environment.EnvironmentKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/ml/environment/ContainingExtender;", "T", "", "Lcom/intellij/platform/ml/environment/EnvironmentExtender;", "containingEnvironment", "Lcom/intellij/platform/ml/environment/Environment;", "tier", "Lcom/intellij/platform/ml/Tier;", "<init>", "(Lcom/intellij/platform/ml/environment/Environment;Lcom/intellij/platform/ml/Tier;)V", "extendingTier", "getExtendingTier", "()Lcom/intellij/platform/ml/Tier;", "extend", "environment", "(Lcom/intellij/platform/ml/environment/Environment;)Ljava/lang/Object;", "requiredTiers", "", "getRequiredTiers", "()Ljava/util/Set;", "intellij.platform.ml"})
public final class ContainingExtender<T>
implements EnvironmentExtender<T> {
    @NotNull
    private final Environment containingEnvironment;
    @NotNull
    private final Tier<T> tier;
    @NotNull
    private final Tier<T> extendingTier;
    @NotNull
    private final Set<Tier<?>> requiredTiers;

    public ContainingExtender(@NotNull Environment containingEnvironment, @NotNull Tier<T> tier) {
        Intrinsics.checkNotNullParameter((Object)containingEnvironment, (String)"containingEnvironment");
        Intrinsics.checkNotNullParameter(tier, (String)"tier");
        this.containingEnvironment = containingEnvironment;
        this.tier = tier;
        this.extendingTier = this.tier;
        this.requiredTiers = SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Tier<T> getExtendingTier() {
        return this.extendingTier;
    }

    @Override
    @NotNull
    public T extend(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return EnvironmentKt.get(this.containingEnvironment, this.tier);
    }

    @Override
    @NotNull
    public Set<Tier<?>> getRequiredTiers() {
        return this.requiredTiers;
    }
}

