/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.reflect.jvm.internal.impl.resolve

import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleCapability
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor
import kotlin.reflect.jvm.internal.impl.descriptors.findClassAcrossModuleDependencies
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds

interface StdlibClassFinder {
    fun findEnumEntriesClass(moduleDescriptor: ModuleDescriptor): ClassDescriptor?
}

/**
 * Default implementation which works for CLI, because all dependencies are added to one module,
 * so we can always find `EnumEntries` there.
 * But this doesn't work for IDE for modules without stdlib in dependencies (e.g. JDK or Kotlin module with `-no-stdlib` specified).
 */
private object CliStdlibClassFinderImpl : StdlibClassFinder {
    override fun findEnumEntriesClass(moduleDescriptor: ModuleDescriptor): ClassDescriptor? {
        return moduleDescriptor.findClassAcrossModuleDependencies(StandardClassIds.EnumEntries)
    }
}

val STDLIB_CLASS_FINDER_CAPABILITY = ModuleCapability<StdlibClassFinder>("StdlibClassFinder")

internal fun ModuleDescriptor.getStdlibClassFinder(): StdlibClassFinder {
    return getCapability(STDLIB_CLASS_FINDER_CAPABILITY) ?: CliStdlibClassFinderImpl
}
