/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class TypeSafeMovingStrategy<T extends PyElement> {
    @NotNull
    private final PyClass myFrom;
    @NotNull
    private final MembersManager<T> myManager;
    @NotNull
    private final Collection<PyMemberInfo<T>> myMemberInfoCollection;
    private final PyClass @NotNull [] myTo;

    static void moveCheckingTypesAtRunTime(@NotNull PyClass from, @NotNull MembersManager<?> manager, @NotNull Collection<? extends PyMemberInfo<PyElement>> memberInfoCollection, PyClass ... to) {
        if (from == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(1);
        }
        if (memberInfoCollection == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(2);
        }
        if (to == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(3);
        }
        manager.checkElementTypes(MembersManager.fetchElements(memberInfoCollection));
        new TypeSafeMovingStrategy(from, manager, memberInfoCollection, to).moveTyped();
    }

    private TypeSafeMovingStrategy(@NotNull PyClass from, @NotNull MembersManager<T> manager, @NotNull Collection<PyMemberInfo<T>> memberInfoCollection, PyClass @NotNull [] to) {
        if (from == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(5);
        }
        if (memberInfoCollection == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(6);
        }
        if (to == null) {
            TypeSafeMovingStrategy.$$$reportNull$$$0(7);
        }
        this.myFrom = from;
        this.myManager = manager;
        this.myMemberInfoCollection = new ArrayList<PyMemberInfo<T>>(memberInfoCollection);
        this.myTo = (PyClass[])to.clone();
    }

    private void moveTyped() {
        Collection<T> elementsCollection = MembersManager.fetchElements(this.myMemberInfoCollection);
        Collection<PyElement> references2 = this.myManager.getElementsToStoreReferences(elementsCollection);
        for (PyElement element : references2) {
            PyClassRefactoringUtil.rememberNamedReferences((PsiElement)element, "self");
        }
        Collection<PyElement> newElements = this.myManager.moveMembers(this.myFrom, this.myMemberInfoCollection, this.myTo);
        for (PyElement element : newElements) {
            PyClassRefactoringUtil.restoreNamedReferences((PsiElement)element, null, references2.toArray(PsiElement.EMPTY_ARRAY));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoCollection";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCheckingTypesAtRunTime";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

