/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split.diff;

import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.actions.diff.lst.SimpleLocalChangeListDiffViewer;
import com.intellij.platform.vcs.backend.split.UtilKt;
import com.intellij.platform.vcs.backend.split.diff.BeDiffMarkHighlighterModelCreatorKt;
import com.intellij.platform.vcs.backend.split.diff.SideBySideChangeModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.daemon.BackendMarkupHost;
import com.jetbrains.rdserver.daemon.BackendMarkupSuppressor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/vcs/backend/split/diff/SideBySideBlockHighlighterGenerator;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "viewer", "Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/diff/tools/simple/SimpleDiffViewer;Lcom/intellij/openapi/client/ClientAppSession;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getViewer", "()Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "lastChangeId", "", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "rebuildBlocks", "", "createBlockHighlighter", "side", "Lcom/intellij/diff/util/Side;", "changeId", "change", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "clearHighlighters", "MyListener", "intellij.platform.vcs.backend.split"})
@SourceDebugExtension(value={"SMAP\nDiffComponentConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffComponentConverter.kt\ncom/intellij/platform/vcs/backend/split/diff/SideBySideBlockHighlighterGenerator\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,394:1\n39#2,5:395\n*S KotlinDebug\n*F\n+ 1 DiffComponentConverter.kt\ncom/intellij/platform/vcs/backend/split/diff/SideBySideBlockHighlighterGenerator\n*L\n200#1:395,5\n*E\n"})
final class SideBySideBlockHighlighterGenerator {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final SimpleDiffViewer viewer;
    @NotNull
    private final ClientAppSession session;
    private long lastChangeId;
    @NotNull
    private final List<RangeHighlighter> highlighters;

    public SideBySideBlockHighlighterGenerator(@NotNull Lifetime lifetime, @NotNull SimpleDiffViewer viewer, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.lifetime = lifetime;
        this.viewer = viewer;
        this.session = session;
        this.highlighters = new ArrayList();
        MyListener listener = new MyListener();
        this.viewer.addListener((DiffViewerListener)listener);
        this.lifetime.onTermination(() -> SideBySideBlockHighlighterGenerator._init_$lambda$0(this, listener));
        this.rebuildBlocks();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final SimpleDiffViewer getViewer() {
        return this.viewer;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rebuildBlocks() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            BackendMarkupSuppressor backendMarkupSuppressor;
            Lifetime blockLifetime = def$iv.getLifetime();
            boolean bl = false;
            BackendMarkupHost backendMarkupHost = BackendMarkupHost.Companion.getInstance(this.session);
            EditorEx editorEx = this.viewer.getEditor1();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor1(...)");
            Object object = backendMarkupHost.getContributor((Editor)editorEx);
            if (object != null && (backendMarkupSuppressor = object.getSuppressor()) != null) {
                backendMarkupSuppressor.suppress(blockLifetime, "SideBySideBlockHighlighterGenerator");
            }
            BackendMarkupHost backendMarkupHost2 = BackendMarkupHost.Companion.getInstance(this.session);
            EditorEx editorEx2 = this.viewer.getEditor2();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"getEditor2(...)");
            object = backendMarkupHost2.getContributor((Editor)editorEx2);
            if (object != null && (backendMarkupSuppressor = object.getSuppressor()) != null) {
                backendMarkupSuppressor.suppress(blockLifetime, "SideBySideBlockHighlighterGenerator");
            }
            this.clearHighlighters();
            for (SimpleDiffChange change : this.viewer.getDiffChanges()) {
                long l = this.lastChangeId;
                this.lastChangeId = l + 1L;
                long changeId = l;
                Collection collection = this.highlighters;
                Intrinsics.checkNotNull((Object)change);
                collection.add(this.createBlockHighlighter(Side.LEFT, changeId, change));
                ((Collection)this.highlighters).add(this.createBlockHighlighter(Side.RIGHT, changeId, change));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    private final RangeHighlighter createBlockHighlighter(Side side, long changeId, SimpleDiffChange change) {
        TextDiffType textDiffType;
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int startLine = change.getStartLine(side);
        int endLine = change.getEndLine(side);
        TextRange textRange = DiffUtil.getLinesRange((Document)((Document)document), (int)startLine, (int)endLine);
        if (change instanceof SimpleLocalChangeListDiffViewer.MySimpleDiffChange && ((SimpleLocalChangeListDiffViewer.MySimpleDiffChange)change).isPartiallyExcluded()) {
            TextDiffType textDiffType2 = TextDiffType.DELETED;
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType2, (String)"DELETED");
            TextDiffType textDiffType3 = TextDiffType.INSERTED;
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType3, (String)"INSERTED");
            textDiffType = (TextDiffType)side.selectNotNull((Object)textDiffType2, (Object)textDiffType3);
        } else {
            textDiffType = change.getDiffType();
        }
        TextDiffType textDiffType4 = textDiffType;
        Intrinsics.checkNotNull((Object)textDiffType4);
        TextDiffType diffType = textDiffType4;
        textDiffType4 = editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 6000, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> SideBySideBlockHighlighterGenerator.createBlockHighlighter$lambda$3(arg_0 -> SideBySideBlockHighlighterGenerator.createBlockHighlighter$lambda$2(changeId, startLine, endLine, document, diffType, change, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)textDiffType4, (String)"addRangeHighlighterAndChangeAttributes(...)");
        return (RangeHighlighter)textDiffType4;
    }

    private final void clearHighlighters() {
        for (RangeHighlighter highlighter : this.highlighters) {
            highlighter.dispose();
        }
        this.highlighters.clear();
    }

    private static final Unit _init_$lambda$0(SideBySideBlockHighlighterGenerator this$0, MyListener $listener) {
        this$0.viewer.removeListener((DiffViewerListener)$listener);
        this$0.clearHighlighters();
        return Unit.INSTANCE;
    }

    private static final Unit createBlockHighlighter$lambda$2(long $changeId, int $startLine, int $endLine, DocumentEx $document, TextDiffType $diffType, SimpleDiffChange $change, RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        BeDiffMarkHighlighterModelCreatorKt.setSideBySideChangeModel((RangeHighlighter)it, new SideBySideChangeModel($changeId, $startLine == $endLine, $endLine == $document.getLineCount(), UtilKt.toMarkerType($diffType), $change.isExcluded(), $change.isSkipped()));
        return Unit.INSTANCE;
    }

    private static final void createBlockHighlighter$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/vcs/backend/split/diff/SideBySideBlockHighlighterGenerator$MyListener;", "Lcom/intellij/diff/tools/util/base/DiffViewerListener;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/diff/SideBySideBlockHighlighterGenerator;)V", "onAfterRediff", "", "intellij.platform.vcs.backend.split"})
    private final class MyListener
    extends DiffViewerListener {
        protected void onAfterRediff() {
            SideBySideBlockHighlighterGenerator.this.rebuildBlocks();
        }
    }
}

