/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t*\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t*\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\t*\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\t*\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\u001a$\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0002\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"editDeviceCgroupArgs", "", "", "arguments", "([Ljava/lang/String;)[Ljava/lang/String;", "DEVICE_CGROUP_RULE_KEY", "DEVICE_CGROUP_RULE_REGEX", "Lkotlin/text/Regex;", "ensureSingleQuotesAreUsed", "", "validate", "validateParts", "parts", "useDoubleQuotes", "joinDeviceCGroupRules", "findDeviceCGroupIndices", "Lkotlin/Pair;", "", "args", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndeviceCGroupUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deviceCGroupUtils.kt\ncom/intellij/docker/agent/util/DeviceCGroupUtilsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,125:1\n37#2:126\n36#2,3:127\n1#3:130\n1563#4:131\n1634#4,3:132\n360#4,7:135\n360#4,7:147\n1740#4,3:154\n221#5,5:142\n1069#5,2:157\n*S KotlinDebug\n*F\n+ 1 deviceCGroupUtils.kt\ncom/intellij/docker/agent/util/DeviceCGroupUtilsKt\n*L\n14#1:126\n14#1:127,3\n85#1:131\n85#1:132,3\n116#1:135,7\n122#1:147,7\n47#1:154,3\n119#1:142,5\n54#1:157,2\n*E\n"})
public final class DeviceCGroupUtilsKt {
    @NotNull
    private static final String DEVICE_CGROUP_RULE_KEY = "--device-cgroup-rule";
    @NotNull
    private static final Regex DEVICE_CGROUP_RULE_REGEX = new Regex("--device-cgroup-rule=(['\"])(.*?)\\1");

    @NotNull
    public static final String[] editDeviceCgroupArgs(@NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Collection $this$toTypedArray$iv = DeviceCGroupUtilsKt.validate(DeviceCGroupUtilsKt.useDoubleQuotes(DeviceCGroupUtilsKt.joinDeviceCGroupRules(DeviceCGroupUtilsKt.ensureSingleQuotesAreUsed(ArraysKt.toList((Object[])arguments)))));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private static final List<String> ensureSingleQuotesAreUsed(List<String> $this$ensureSingleQuotesAreUsed) {
        Object v0;
        block2: {
            Iterable iterable = $this$ensureSingleQuotesAreUsed;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)DEVICE_CGROUP_RULE_KEY, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (char)'\'', (boolean)false, (int)2, null))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((String)v0 == null) {
            return $this$ensureSingleQuotesAreUsed;
        }
        throw new ParseException("Please use single quotes when setting the --device-cgroup-rule");
    }

    private static final List<String> validate(List<String> $this$validate) {
        for (String arg : $this$validate) {
            int n;
            MatchResult res;
            CharSequence charSequence;
            Regex regex;
            String errorMsg;
            if (DEVICE_CGROUP_RULE_REGEX.matchEntire((CharSequence)arg) == null || (errorMsg = DeviceCGroupUtilsKt.validateParts((regex = new Regex("\\s+")).split(charSequence = (CharSequence)((Object)StringsKt.trim((CharSequence)((String)res.getGroupValues().get(2)))).toString(), n = 0))) == null) continue;
            throw new ParseException(errorMsg);
        }
        return $this$validate;
    }

    private static final String validateParts(List<String> parts) {
        int currentState = 1;
        String errorPrefix = "Invalid device cgroup format";
        for (String part : parts) {
            String errorMsg;
            Pair<Integer, String> pair = DeviceCGroupUtilsKt.validateParts$transition(part, currentState);
            int nextState = ((Number)pair.component1()).intValue();
            String string = errorMsg = (String)pair.component2();
            if (string != null) {
                return errorPrefix + ". " + string;
            }
            currentState = nextState;
        }
        Object[] objectArray = new Integer[]{1, 3, 5};
        return !CollectionsKt.listOf((Object[])objectArray).contains(currentState) ? errorPrefix + ". Looks like you've entered an incomplete rule. Example rule: 'c 42:* rmw'" : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> useDoubleQuotes(List<String> $this$useDoubleQuotes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$useDoubleQuotes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void arg;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (DEVICE_CGROUP_RULE_REGEX.containsMatchIn((CharSequence)arg)) {
                CharSequence charSequence = (CharSequence)arg;
                Regex regex = DEVICE_CGROUP_RULE_REGEX;
                Function1 function1 = DeviceCGroupUtilsKt::useDoubleQuotes$lambda$5$lambda$4;
                string = regex.replace(charSequence, function1);
            } else {
                string = arg;
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private static final List<String> joinDeviceCGroupRules(List<String> $this$joinDeviceCGroupRules) {
        Pair<Integer, Integer> pair = DeviceCGroupUtilsKt.findDeviceCGroupIndices($this$joinDeviceCGroupRules);
        if (pair == null) {
            return $this$joinDeviceCGroupRules;
        }
        Pair<Integer, Integer> pair2 = pair;
        int leftInd = ((Number)pair2.component1()).intValue();
        int rightInd = ((Number)pair2.component2()).intValue();
        List<String> leftPart = $this$joinDeviceCGroupRules.subList(0, leftInd);
        String midElem = CollectionsKt.joinToString$default((Iterable)$this$joinDeviceCGroupRules.subList(leftInd, rightInd), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        List<String> rightPart = $this$joinDeviceCGroupRules.subList(rightInd, $this$joinDeviceCGroupRules.size());
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)leftPart, (Object)midElem), (Iterable)DeviceCGroupUtilsKt.joinDeviceCGroupRules(rightPart));
    }

    private static final Pair<Integer, Integer> findDeviceCGroupIndices(List<String> args) {
        int n;
        int startingInd;
        int keyInd;
        block10: {
            Character c;
            block9: {
                block8: {
                    int n2;
                    List<String> $this$indexOfFirst$iv = args;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        String item$iv;
                        String it = item$iv = iterator.next();
                        boolean bl = false;
                        if (StringsKt.startsWith$default((String)it, (String)"--device-cgroup-rule=", (boolean)false, (int)2, null)) {
                            n2 = index$iv;
                            break block8;
                        }
                        ++index$iv;
                    }
                    n2 = keyInd = -1;
                }
                if (keyInd == -1) {
                    return null;
                }
                CharSequence $this$lastOrNull$iv = args.get(keyInd);
                boolean $i$f$lastOrNull = false;
                int item$iv = $this$lastOrNull$iv.length() + -1;
                if (0 <= item$iv) {
                    do {
                        char element$iv;
                        int index$iv = item$iv--;
                        char it = element$iv = $this$lastOrNull$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == '\'' || it == '\"')) continue;
                        c = Character.valueOf(element$iv);
                        break block9;
                    } while (0 <= item$iv);
                }
                c = null;
            }
            if (c == null) {
                return null;
            }
            char quote = c.charValue();
            startingInd = keyInd + 1;
            List $this$indexOfFirst$iv = CollectionsKt.drop((Iterable)args, (int)startingInd);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.last((CharSequence)it) == quote) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = -1;
        }
        int relativeRightInd = n;
        int rightInd = startingInd + relativeRightInd + 1;
        return relativeRightInd == -1 ? null : TuplesKt.to((Object)keyInd, (Object)rightInd);
    }

    private static final String validateParts$checkType(String s) {
        return s.length() != 1 || !StringsKt.contains$default((CharSequence)"abc", (char)s.charAt(0), (boolean)false, (int)2, null) ? "'" + s + "' is an incorrect type. It should be either 'a', 'c' or 'b'" : null;
    }

    private static final String validateParts$checkNumbers(String s) {
        boolean bl;
        block5: {
            String[] stringArray = new String[]{":"};
            List numbers = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (numbers.size() != 2) {
                return "'" + s + "' - major and minor numbers should be formatted as <major>:<minor>";
            }
            Iterable $this$all$iv = numbers;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)"*") || StringsKt.toIntOrNull((String)it) != null) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) {
            return "'" + s + "' - major and minor values should be either a number or '*'";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String validateParts$checkPermissions(String s) {
        block3: {
            if (((CharSequence)s).length() == 0) {
                return null;
            }
            boolean bl = false;
            if (bl) return null;
            CharSequence $this$all$iv = s;
            boolean $i$f$all = false;
            int n = 0;
            while (n < $this$all$iv.length()) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n);
                boolean bl2 = false;
                if (StringsKt.contains$default((CharSequence)"rwm", (char)it, (boolean)false, (int)2, null)) {
                    ++n;
                    continue;
                }
                break block3;
            }
            return null;
        }
        boolean bl = false;
        if (bl) return null;
        String string = "'" + s + "' permissions are incorrect. It should include any of 'r', 'w' or 'm'";
        return string;
    }

    private static final Pair<Integer, String> validateParts$transition$orElse(Pair<Integer, String> $this$validateParts_u24transition_u24orElse, Function0<Pair<Integer, String>> other) {
        return $this$validateParts_u24transition_u24orElse.getSecond() == null ? $this$validateParts_u24transition_u24orElse : (Pair)other.invoke();
    }

    private static final Pair validateParts$transition$lambda$3(String $part) {
        return TuplesKt.to((Object)1, (Object)DeviceCGroupUtilsKt.validateParts$checkPermissions($part));
    }

    private static final Pair<Integer, String> validateParts$transition(String part, int curStep) {
        return switch (curStep) {
            case 1 -> TuplesKt.to((Object)2, (Object)DeviceCGroupUtilsKt.validateParts$checkType(part));
            case 2 -> TuplesKt.to((Object)3, (Object)DeviceCGroupUtilsKt.validateParts$checkNumbers(part));
            case 3 -> DeviceCGroupUtilsKt.validateParts$transition$orElse((Pair<Integer, String>)TuplesKt.to((Object)2, (Object)DeviceCGroupUtilsKt.validateParts$checkType(part)), (Function0<Pair<Integer, String>>)((Function0)() -> DeviceCGroupUtilsKt.validateParts$transition$lambda$3(part)));
            default -> TuplesKt.to((Object)1, (Object)"");
        };
    }

    private static final CharSequence useDoubleQuotes$lambda$5$lambda$4(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "--device-cgroup-rule=\"" + it.getGroupValues().get(2) + "\"";
    }
}

