/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQuotesUtil;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyQuotedStringIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public PyQuotedStringIntention() {
        super(PsiElement.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(1);
        }
        if (!(context.file() instanceof PyFile)) {
            return null;
        }
        PyStringElement stringElement = PyQuotedStringIntention.findConvertibleStringElementUnderCaret(element);
        if (stringElement == null) {
            return null;
        }
        PyStringLiteralExpression stringLiteral = PyUtil.as(stringElement.getParent(), PyStringLiteralExpression.class);
        if (stringLiteral == null) {
            return null;
        }
        PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)stringLiteral, PyDocStringOwner.class);
        if (docStringOwner != null && docStringOwner.getDocStringExpression() == stringLiteral) {
            return null;
        }
        String currentQuote = stringElement.getQuote();
        if (currentQuote.equals("'")) {
            return Presentation.of((String)PyPsiBundle.message("INTN.quoted.string.single.to.double", new Object[0]));
        }
        return Presentation.of((String)PyPsiBundle.message("INTN.quoted.string.double.to.single", new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.quoted.string", new Object[0]);
        if (string == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static PyStringElement findConvertibleStringElementUnderCaret(@NotNull PsiElement element) {
        IElementType elementType;
        if (element == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(3);
        }
        if (!PyTokenTypes.STRING_NODES.contains(elementType = element.getNode().getElementType()) && !PyTokenTypes.FSTRING_TOKENS.contains(elementType)) {
            return null;
        }
        PyStringElement stringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyStringElement.class, (boolean)false, (Class[])new Class[]{PyExpression.class});
        return stringElement != null && PyQuotesUtil.canBeConverted(stringElement, true) ? stringElement : null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PyStringElement stringElement;
        if (context == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(6);
        }
        if ((stringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyStringElement.class, (boolean)false, (Class[])new Class[]{PyExpression.class})) == null) {
            return;
        }
        PyStringLiteralExpression stringLiteral = PyUtil.as(stringElement.getParent(), PyStringLiteralExpression.class);
        if (stringLiteral == null) {
            return;
        }
        String originalQuote = stringElement.getQuote();
        boolean entireLiteralCanBeConverted = ContainerUtil.all(stringLiteral.getStringElements(), s -> s.getQuote().equals(originalQuote) && PyQuotesUtil.canBeConverted(s, true));
        if (entireLiteralCanBeConverted) {
            stringLiteral.getStringElements().forEach(PyQuotedStringIntention::convertStringElement);
        } else {
            PyQuotedStringIntention.convertStringElement(stringElement);
        }
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiFile file) {
        Presentation presentation;
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(8);
        }
        return (presentation = this.getPresentation(ActionContext.from((Editor)editor2, (PsiFile)file))) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiFile file) {
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(10);
        }
        ActionContext context = ActionContext.from((Editor)editor2, (PsiFile)file);
        ModCommandExecutor.executeInteractively((ActionContext)context, (String)this.getFamilyName(), (Editor)editor2, () -> this.perform(context));
    }

    private static void convertStringElement(@NotNull PyStringElement stringElement) {
        if (stringElement == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(11);
        }
        stringElement.replace(PyQuotesUtil.createCopyWithConvertedQuotes(stringElement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConvertibleStringElementUnderCaret";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertStringElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

