/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReactUtil {
    public static final String ALT_DEFAULT_NAME = "alt.default.name";
    public static final Set<String> REACT_COMPONENT_NAMES = Set.of("Component", "PureComponent", "NativeComponent");
    public static final Set<String> REACT_SINGLE_VARIANT_COMPONENT_NAMES = Set.of("StatelessComponent", "ComponentType", "ComponentClass", "FunctionComponent", "SFC", "RefForwardingComponent", "FC", "ForwardRefExoticComponent");
    public static final Set<String> REACT_SINGLE_VARIANT_COMPONENT_NAMES_WITH_REACT_PREFIX = REACT_SINGLE_VARIANT_COMPONENT_NAMES.stream().map(el -> "React." + el).collect(Collectors.toUnmodifiableSet());
    public static final String FRAGMENT_NAME = "Fragment";
    public static final String CONTEXT_TYPES_PROPERTY = "contextTypes";
    public static final String DISPLAY_NAME_PROPERTY = "displayName";
    public static final String CHILD_CONTEXT_TYPES_PROPERTY = "childContextTypes";
    public static final String PROP_TYPES_PROPERTY = "propTypes";
    public static final String DEFAULT_PROPS_PROPERTY = "defaultProps";
    public static final String GET_DEFAULT_PROPS_METHOD = "getDefaultProps";
    public static final String RENDER_METHOD = "render";
    public static final String CONTEXT_PROPERTY = "context";
    public static final String SET_STATE_METHOD = "setState";
    public static final String PROPS = "props";
    public static final String STATE = "state";
    public static final String REACT_DEFAULT_MODULE_NAME = "react";
    public static final String REACT = "React";
    public static final String REACT_PROP_TYPES = "PropTypes";
    public static final String PROP_TYPES_MODULE_NAME = "prop-types";
    public static final String REACT_NODE = "ReactNode";

    private ReactUtil() {
    }

    public static boolean isReactComponentCall(@Nullable JSExpression expression) {
        if (!(expression instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)expression;
        JSExpression methodExpression = (JSExpression)AstLoadingFilter.forceAllowTreeLoading((PsiFile)callExpression.getContainingFile(), () -> callExpression.getMethodExpression());
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        return JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, REACT, "createClass") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "createReactClass") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, REACT, "forwardRef");
    }

    @Nullable
    public static JSImplicitElement substitutePropTypesPropDeclaration(@NotNull JSProperty property) {
        if (property == null) {
            ReactUtil.$$$reportNull$$$0(0);
        }
        if (ReactUtil.isNamespaceMember(property, PROP_TYPES_PROPERTY)) {
            Collection<JSImplicitElement> implicitElements;
            JSElementIndexingData indexingData = property.getIndexingData();
            Collection<JSImplicitElement> collection = implicitElements = indexingData != null ? indexingData.getImplicitElements() : null;
            if (implicitElements == null) {
                return null;
            }
            for (JSImplicitElement element2 : implicitElements) {
                if (!ReactUtil.isNamespaceMember(element2, PROPS)) continue;
                return element2;
            }
            return null;
        }
        if (ReactUtil.isNamespaceMember(property, DEFAULT_PROPS_PROPERTY, GET_DEFAULT_PROPS_METHOD)) {
            JSQualifiedName namespace = property.getNamespace();
            assert (namespace != null);
            JSQualifiedName parent = namespace.getParent();
            assert (parent != null);
            Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(parent.getQualifiedName() + ".props." + property.getName(), property.getResolveScope());
            for (JSPsiElementBase element3 : elements) {
                if (!(element3 instanceof JSImplicitElement)) continue;
                return (JSImplicitElement)element3;
            }
        }
        return null;
    }

    public static boolean isNamespaceMember(@NotNull JSPsiElementBase element2, String ... namespaceNames) {
        JSQualifiedName namespace;
        if (element2 == null) {
            ReactUtil.$$$reportNull$$$0(1);
        }
        if (namespaceNames == null) {
            ReactUtil.$$$reportNull$$$0(2);
        }
        return (namespace = element2.getNamespace()) != null && ArrayUtil.contains((String)namespace.getName(), (String[])namespaceNames) && namespace.getParent() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceNames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "substitutePropTypesPropDeclaration";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNamespaceMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

