/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.util;

import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.tailwind.settings.TailwindSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TailwindUtil {
    public static final String TAILWIND_CONFIG_NAME = "tailwind.config";
    private static final String TAILWIND_CSS_PACKAGE_NAME = "tailwindcss";
    private static final String[] TAILWIND_ENABLING_PACKAGES = new String[]{"tailwindcss", "@nuxtjs/tailwindcss"};

    private TailwindUtil() {
    }

    public static boolean isTailwindProject(@NotNull Project project, @NotNull VirtualFile contextFileOrDir) {
        VirtualFile packageJson;
        if (project == null) {
            TailwindUtil.$$$reportNull$$$0(0);
        }
        if (contextFileOrDir == null) {
            TailwindUtil.$$$reportNull$$$0(1);
        }
        if ((packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)contextFileOrDir)) == null) {
            return false;
        }
        YarnPnpManager yarnPnpManager = YarnPnpManager.getInstance((Project)project);
        if (yarnPnpManager.isUnderPnp(packageJson) && yarnPnpManager.hasDirectOrIndirectDependency(packageJson, TAILWIND_CSS_PACKAGE_NAME)) {
            return true;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, packageJson);
        for (String packageName : TAILWIND_ENABLING_PACKAGES) {
            if (finder.findInstalledPackage(packageName) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile getTailwindCssPackageDir(@NotNull Project project, @NotNull VirtualFile contextFileOrDir) {
        VirtualFile packageJson;
        if (project == null) {
            TailwindUtil.$$$reportNull$$$0(2);
        }
        if (contextFileOrDir == null) {
            TailwindUtil.$$$reportNull$$$0(3);
        }
        if ((packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)contextFileOrDir)) == null) {
            return null;
        }
        InstalledPackageVersion tailwindCssPackage = new NodeInstalledPackageFinder(project, packageJson).findInstalledPackage(TAILWIND_CSS_PACKAGE_NAME);
        if (tailwindCssPackage == null) {
            return null;
        }
        return tailwindCssPackage.getPackageDir();
    }

    public static boolean isSupportedFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TailwindUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            TailwindUtil.$$$reportNull$$$0(5);
        }
        return TailwindUtil.isStandardSupportedLanguage(project, file) || TailwindUtil.isCustomSupportedLanguage(project, file);
    }

    private static boolean isStandardSupportedLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        FileViewProvider viewProvider;
        if (project == null) {
            TailwindUtil.$$$reportNull$$$0(6);
        }
        if (file == null) {
            TailwindUtil.$$$reportNull$$$0(7);
        }
        if ((viewProvider = PsiManager.getInstance((Project)project).findViewProvider(file)) != null) {
            for (Language language : viewProvider.getLanguages()) {
                if (!language.isKindOf((Language)CSSLanguage.INSTANCE) && !language.isKindOf((Language)HTMLLanguage.INSTANCE) && !language.isKindOf((Language)JavascriptLanguage.INSTANCE)) continue;
                return true;
            }
        }
        return ArrayUtil.contains((String)StringUtil.toLowerCase((String)file.getExtension()), (String[])new String[]{"pug", "jade"});
    }

    private static boolean isCustomSupportedLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        String languageId;
        if (project == null) {
            TailwindUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            TailwindUtil.$$$reportNull$$$0(9);
        }
        return !(languageId = LspServerDescriptor.Companion.getLanguageId(file)).isEmpty() && TailwindSettings.hasCustomLanguage(project, languageId);
    }

    public static boolean isTailwindConfigFile(PsiFile file) {
        if (file.getName().startsWith(TAILWIND_CONFIG_NAME)) {
            return true;
        }
        if (!(file instanceof StylesheetFile)) {
            return false;
        }
        List importElements = ((StylesheetFile)file).getStylesheet().getImports();
        return ContainerUtil.exists((Iterable)importElements, element -> ContainerUtil.exists((Object[])element.getUriStrings(), s -> s.equals(TAILWIND_CSS_PACKAGE_NAME)));
    }

    public static boolean canBeTailwindCssClassNamePart(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            TailwindUtil.$$$reportNull$$$0(10);
        }
        IElementType type = (node = element.getNode()) != null ? node.getElementType() : null;
        return type == CssElementTypes.CSS_IDENT || type == CssElementTypes.CSS_COLON || type == CssElementTypes.CSS_NUMBER || type == CssElementTypes.CSS_MINUS || type == CssElementTypes.CSS_SLASH || type == CssElementTypes.CSS_LBRACKET || type == CssElementTypes.CSS_RBRACKET;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFileOrDir";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tailwind/util/TailwindUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTailwindProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTailwindCssPackageDir";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isStandardSupportedLanguage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomSupportedLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeTailwindCssClassNamePart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

