/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterPsiFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0007\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014\"\u001d\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\u0019"}, d2={"JUPYTER_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/editor/Editor;", "getJUPYTER_EDITOR_KEY", "()Lcom/intellij/openapi/util/Key;", "NOTEBOOK_VIRTUAL_FILE_KEY", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getNOTEBOOK_VIRTUAL_FILE_KEY", "toJupyterCellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "document", "Lcom/intellij/openapi/editor/Document;", "toJupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "file", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "toEditorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "intellij.jupyter.core"})
public final class JupyterCellLinesExtensionsKt {
    @NotNull
    private static final Key<WeakReference<Editor>> JUPYTER_EDITOR_KEY;
    @NotNull
    private static final Key<BackedNotebookVirtualFile> NOTEBOOK_VIRTUAL_FILE_KEY;

    @NotNull
    public static final Key<WeakReference<Editor>> getJUPYTER_EDITOR_KEY() {
        return JUPYTER_EDITOR_KEY;
    }

    @NotNull
    public static final Key<BackedNotebookVirtualFile> getNOTEBOOK_VIRTUAL_FILE_KEY() {
        return NOTEBOOK_VIRTUAL_FILE_KEY;
    }

    @NotNull
    public static final JupyterCellType toJupyterCellType(@NotNull NotebookCellLines.CellType $this$toJupyterCellType) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCellType, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toJupyterCellType.ordinal()]) {
            case 1 -> JupyterCellType.RAW;
            case 2 -> JupyterCellType.MARKDOWN;
            case 3 -> JupyterCellType.CODE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final JupyterCellType toJupyterCellType(@NotNull NotebookCellLines.Interval $this$toJupyterCellType, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCellType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String topMarker = $this$toJupyterCellType.getTopMarker(document);
        if (Intrinsics.areEqual((Object)topMarker, (Object)"#%% sql")) {
            return JupyterCellType.SQL;
        }
        if (Intrinsics.areEqual((Object)topMarker, (Object)"#%% data_input")) {
            return JupyterCellType.DATA_INPUT;
        }
        return JupyterCellLinesExtensionsKt.toJupyterCellType($this$toJupyterCellType.getType());
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookCellLines.Interval $this$toJupyterCell, @NotNull JupyterFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiFileExtensionsKt.getNotebookVirtualFile(psiFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile file = backedNotebookVirtualFile;
        return JupyterCellLinesExtensionsKt.toJupyterCell($this$toJupyterCell, file);
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookCellLines.Interval $this$toJupyterCell, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor);
        return jupyterNotebook != null ? jupyterNotebook.getCellOrNull($this$toJupyterCell.getOrdinal()) : null;
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookCellLines.Interval $this$toJupyterCell, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JupyterNotebook jupyterNotebook = file.getNotebookOrNull();
        return jupyterNotebook != null ? jupyterNotebook.getCellOrNull($this$toJupyterCell.getOrdinal()) : null;
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookIntervalPointer $this$toJupyterCell, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookCellLines.Interval interval = $this$toJupyterCell.get();
        return interval != null ? JupyterCellLinesExtensionsKt.toJupyterCell(interval, editor) : null;
    }

    @Nullable
    public static final JupyterCell toJupyterCell(@NotNull NotebookIntervalPointer $this$toJupyterCell, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$toJupyterCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        NotebookCellLines.Interval interval = $this$toJupyterCell.get();
        return interval != null ? JupyterCellLinesExtensionsKt.toJupyterCell(interval, file) : null;
    }

    @Nullable
    public static final EditorCell toEditorCell(@NotNull NotebookIntervalPointer $this$toEditorCell, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)$this$toEditorCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)editor);
        return notebookCellInlayManager != null ? notebookCellInlayManager.getCell($this$toEditorCell) : null;
    }

    static {
        Key key = Key.create((String)"JUPYTER_EDITOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JUPYTER_EDITOR_KEY = key;
        Key key2 = Key.create((String)"NOTEBOOK_VIRTUAL_FILE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        NOTEBOOK_VIRTUAL_FILE_KEY = key2;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookCellLines.CellType.values().length];
            try {
                nArray[NotebookCellLines.CellType.RAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.CODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

