/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyCellUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PyCellsFoldingBuilder
extends CustomFoldingBuilder {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            PyCellsFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PyCellsFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            PyCellsFoldingBuilder.$$$reportNull$$$0(2);
        }
        PyCellsFoldingBuilder.appendDescriptors(root.getNode(), descriptors);
    }

    private static void appendDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (PyCellUtil.isBlockCell((PsiElement)node.getPsi())) {
            PsiElement el = PyCellUtil.findNextCell((PsiElement)node.getPsi());
            int startOffset = node.getStartOffset();
            int endOffset = el == null ? node.getPsi().getContainingFile().getTextLength() : el.getTextOffset();
            descriptors.add(new FoldingDescriptor(node, TextRange.create((int)startOffset, (int)(endOffset - 1))));
            el = PyCellUtil.findPrevCell((PsiElement)node.getPsi());
            if (el == null && startOffset > 1) {
                descriptors.add(new FoldingDescriptor(PsiTreeUtil.getDeepestFirst((PsiElement)node.getPsi().getContainingFile()).getNode(), TextRange.create((int)0, (int)(startOffset - 1))));
            }
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PyCellsFoldingBuilder.appendDescriptors(child, descriptors);
        }
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            PyCellsFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            PyCellsFoldingBuilder.$$$reportNull$$$0(4);
        }
        return node.getText();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PyCellsFoldingBuilder.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/scientific/cells/PyCellsFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

