/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer;

import com.intellij.python.scientific.powerfuldataviewer.DataViewTableImpl;
import java.util.Collections;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class CustomRowSorter
extends RowSorter<TableModel> {
    private final DataViewTableImpl myTable;
    private RowSorter.SortKey mySortKey;

    public CustomRowSorter(@NotNull DataViewTableImpl table) {
        if (table == null) {
            CustomRowSorter.$$$reportNull$$$0(0);
        }
        this.myTable = table;
        this.reset();
    }

    public void reset() {
        this.mySortKey = new RowSorter.SortKey(0, SortOrder.UNSORTED);
    }

    public RowSorter.SortKey getSortKey() {
        return this.mySortKey;
    }

    @Override
    public TableModel getModel() {
        return this.myTable.getModel();
    }

    @Override
    public void toggleSortOrder(int column) {
        if (column < 0 || column >= this.getModel().getColumnCount()) {
            throw new IllegalArgumentException("Column is out of range");
        }
        SortOrder order = this.mySortKey.getColumn() != column ? SortOrder.UNSORTED : this.mySortKey.getSortOrder();
        this.mySortKey = new RowSorter.SortKey(column, CustomRowSorter.toggleSortOrder(order));
        this.myTable.setSortKey(this.mySortKey);
        this.myTable.getTableHeader().repaint();
    }

    @NotNull
    private static SortOrder toggleSortOrder(@NotNull SortOrder order) {
        if (order == null) {
            CustomRowSorter.$$$reportNull$$$0(1);
        }
        SortOrder sortOrder = switch (order) {
            default -> throw new IncompatibleClassChangeError();
            case SortOrder.ASCENDING -> SortOrder.DESCENDING;
            case SortOrder.DESCENDING -> SortOrder.UNSORTED;
            case SortOrder.UNSORTED -> SortOrder.ASCENDING;
        };
        if (sortOrder == null) {
            CustomRowSorter.$$$reportNull$$$0(2);
        }
        return sortOrder;
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return index;
    }

    @Override
    public int convertRowIndexToView(int index) {
        return index;
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return Collections.singletonList(this.mySortKey);
    }

    @Override
    public int getViewRowCount() {
        return this.getModel().getRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.getModel().getRowCount();
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/scientific/powerfuldataviewer/CustomRowSorter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/scientific/powerfuldataviewer/CustomRowSorter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleSortOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toggleSortOrder";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

