/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraOciValidator
extends DatabaseConfigValidator<LocalDataSource> {
    private static final String ORACLE_HOME = "ORACLE_HOME";

    @Override
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        String url;
        if (project == null) {
            OraOciValidator.$$$reportNull$$$0(0);
        }
        if (target == null) {
            OraOciValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            OraOciValidator.$$$reportNull$$$0(2);
        }
        if ((url = target.getUrl()) == null || !StringUtil.startsWithIgnoreCase((String)url, (String)"jdbc:oracle:oci")) {
            return;
        }
        DatabaseDriver driver = target.getDatabaseDriver();
        String oraHome = (String)target.getVmEnv().get(ORACLE_HOME);
        if (StringUtil.isEmpty((String)oraHome) && driver != null) {
            oraHome = (String)driver.getVmEnv().get(ORACLE_HOME);
        }
        if (StringUtil.isEmpty((String)oraHome)) {
            oraHome = EnvironmentUtil.getValue((String)ORACLE_HOME);
        }
        if (StringUtil.isNotEmpty((String)oraHome)) {
            return;
        }
        DatabaseFixFactory factory = DatabaseFixFactory.getInstance();
        ErrorInfo.Fix fix = factory == null ? null : factory.setVmEnv("", target, ORACLE_HOME, "path");
        DataSourceProblem.HyperText text = new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.oracle.home.not.defined", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.oracle.home.should.be.defined", (Object[])new Object[0]) + DatabaseBundle.message((String)"notification.content.oracle.home.should.be.defined.action", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.oracle.home.should.be.defined", (Object[])new Object[0]), fix);
        problems.consume((Object)new DataSourceProblem(target, ORACLE_HOME, DataSourceProblem.Level.ERROR, text, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "problems";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/oracle/OraOciValidator";
        objectArray[2] = "collectProblems";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

