/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.junit.jupiter;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

@Deprecated
public class SoftlyExtension
implements AfterTestExecutionCallback,
TestInstancePostProcessor {
    private static final ExtensionContext.Namespace SOFTLY_EXTENSION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SoftlyExtension.class});

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        if (SoftlyExtension.isPerClassLifeCycle(extensionContext)) {
            throw new IllegalStateException("A SoftAssertions field is not permitted in test classes with PER_CLASS life cycle as the instance would be collecting all class tests errors (instead of per test errors). Consider using {@link SoftAssertionsExtension} instead which does not have such limitation.");
        }
        SoftlyExtension.initSoftAssertionsField(testInstance).ifPresent(softAssertions -> SoftlyExtension.getStore(extensionContext).put(SoftlyExtension.class, softAssertions));
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        SoftAssertions softAssertions = (SoftAssertions)SoftlyExtension.getStore(extensionContext).remove(SoftlyExtension.class, SoftAssertions.class);
        Optional<ExtensionContext> currentContext = Optional.of(extensionContext);
        while (softAssertions == null && SoftlyExtension.getParent(currentContext).isPresent()) {
            softAssertions = SoftlyExtension.getParent(currentContext).map(context -> (SoftAssertions)SoftlyExtension.getStore(context).remove(SoftlyExtension.class, SoftAssertions.class)).orElse(null);
            currentContext = SoftlyExtension.getParent(currentContext);
        }
        if (softAssertions == null) {
            throw new IllegalStateException("No SoftlyExtension field found");
        }
        softAssertions.assertAll();
    }

    private static Optional<ExtensionContext> getParent(Optional<ExtensionContext> currentContext) {
        return currentContext.flatMap(ExtensionContext::getParent);
    }

    private static boolean isPerClassLifeCycle(ExtensionContext methodExtensionContext) {
        return methodExtensionContext.getTestInstanceLifecycle().map(lifecycle -> lifecycle == TestInstance.Lifecycle.PER_CLASS).orElse(false);
    }

    private static Optional<SoftAssertions> initSoftAssertionsField(Object testInstance) throws IllegalAccessException {
        List softAssertionsFields = ReflectionSupport.findFields(testInstance.getClass(), field -> field.getType() == SoftAssertions.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        if (softAssertionsFields.isEmpty()) {
            return Optional.empty();
        }
        SoftlyExtension.checkTooManySoftAssertionsFields(softAssertionsFields);
        Field softAssertionsField = (Field)softAssertionsFields.iterator().next();
        softAssertionsField.setAccessible(true);
        SoftAssertions softAssertions = new SoftAssertions();
        softAssertionsField.set(testInstance, softAssertions);
        return Optional.of(softAssertions);
    }

    private static void checkTooManySoftAssertionsFields(Collection<Field> softAssertionsFields) {
        if (softAssertionsFields.size() > 1) {
            throw new IllegalStateException("Only one field of type " + SoftAssertions.class.getName() + " should be defined but found " + softAssertionsFields.size() + " : " + softAssertionsFields);
        }
    }

    private static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(SOFTLY_EXTENSION_NAMESPACE);
    }
}

