/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.ChatRequestValidationUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.InternalAnthropicHelper;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTextContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolChoice;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.anthropic.internal.sanitizer.MessageSanitizer;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnthropicStreamingChatModel
implements StreamingChatModel {
    private static final Logger log = LoggerFactory.getLogger(AnthropicStreamingChatModel.class);
    private final AnthropicClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;
    private final int maxTokens;
    private final List<String> stopSequences;
    private final boolean cacheSystemMessages;
    private final boolean cacheTools;
    private final String thinkingType;
    private final Integer thinkingBudgetTokens;
    private final List<ChatModelListener> listeners;

    private AnthropicStreamingChatModel(String baseUrl, String apiKey, String version, String beta, String modelName, Double temperature, Double topP, Integer topK, Integer maxTokens, List<String> stopSequences, Boolean cacheSystemMessages, Boolean cacheTools, String thinkingType, Integer thinkingBudgetTokens, Duration timeout2, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners) {
        this.client = ((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)AnthropicClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.anthropic.com/v1/"))).apiKey(apiKey)).version((String)Utils.getOrDefault((Object)version, (Object)"2023-06-01"))).beta(beta)).timeout((Duration)Utils.getOrDefault((Object)timeout2, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.maxTokens = (Integer)Utils.getOrDefault((Object)maxTokens, (Object)1024);
        this.stopSequences = stopSequences;
        this.cacheSystemMessages = (Boolean)Utils.getOrDefault((Object)cacheSystemMessages, (Object)false);
        this.cacheTools = (Boolean)Utils.getOrDefault((Object)cacheTools, (Object)false);
        this.thinkingType = thinkingType;
        this.thinkingBudgetTokens = thinkingBudgetTokens;
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    public static AnthropicStreamingChatModelBuilder builder() {
        return new AnthropicStreamingChatModelBuilder();
    }

    public void chat(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidationUtils.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidationUtils.validate((ResponseFormat)parameters.responseFormat());
        StreamingResponseHandler<AiMessage> legacyHandler = new StreamingResponseHandler<AiMessage>(){

            public void onNext(String token) {
                handler.onPartialResponse(token);
            }

            public void onComplete(Response<AiMessage> response) {
                ChatResponse chatResponse = ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
                handler.onCompleteResponse(chatResponse);
            }

            public void onError(Throwable error) {
                handler.onError(error);
            }
        };
        List toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            this.generate(chatRequest.messages(), legacyHandler);
        } else if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            if (toolSpecifications.size() != 1) {
                throw new UnsupportedFeatureException(String.format("%s.%s is currently supported only when there is a single tool", ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
            }
            this.generate((List<ChatMessage>)chatRequest.messages(), (ToolSpecification)toolSpecifications.get(0), legacyHandler);
        } else {
            this.generate((List<ChatMessage>)chatRequest.messages(), toolSpecifications, legacyHandler);
        }
    }

    private void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, null, handler);
    }

    private void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, toolSpecifications, null, handler);
    }

    private void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, toolSpecification, handler);
    }

    private void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, final StreamingResponseHandler<AiMessage> handler) {
        AnthropicCacheType toolsCacheType;
        List<ChatMessage> sanitizedMessages = MessageSanitizer.sanitizeMessages(messages);
        List<AnthropicTextContent> systemPrompt = AnthropicMapper.toAnthropicSystemPrompt(messages, this.cacheSystemMessages ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE);
        ValidationUtils.ensureNotNull(handler, (String)"handler");
        AnthropicCreateMessageRequest.Builder requestBuilder = AnthropicCreateMessageRequest.builder().stream(true).model(this.modelName).messages(AnthropicMapper.toAnthropicMessages(sanitizedMessages)).system(systemPrompt).maxTokens(this.maxTokens).stopSequences(this.stopSequences).temperature(this.temperature).topP(this.topP).topK(this.topK).thinking(AnthropicChatModel.toThinking(this.thinkingType, this.thinkingBudgetTokens));
        AnthropicCacheType anthropicCacheType = toolsCacheType = this.cacheTools ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE;
        if (toolThatMustBeExecuted != null) {
            requestBuilder.tools(AnthropicMapper.toAnthropicTools(Collections.singletonList(toolThatMustBeExecuted), toolsCacheType));
            requestBuilder.toolChoice(AnthropicToolChoice.from(toolThatMustBeExecuted.name()));
        } else if (!Utils.isNullOrEmpty(toolSpecifications)) {
            requestBuilder.tools(AnthropicMapper.toAnthropicTools(toolSpecifications, toolsCacheType));
        }
        AnthropicCreateMessageRequest request = requestBuilder.build();
        final ChatRequest listenerRequest = InternalAnthropicHelper.createListenerRequest(request, messages, toolSpecifications);
        final ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(listenerRequest, this.provider(), attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", e);
            }
        });
        StreamingResponseHandler<AiMessage> listenerHandler = new StreamingResponseHandler<AiMessage>(){

            public void onNext(String token) {
                handler.onNext(token);
            }

            public void onError(Throwable error) {
                ChatModelErrorContext errorContext = InternalAnthropicHelper.createErrorContext(error, listenerRequest, AnthropicStreamingChatModel.this.provider(), attributes);
                AnthropicStreamingChatModel.this.listeners.forEach(listener -> {
                    try {
                        listener.onError(errorContext);
                    }
                    catch (Exception e2) {
                        log.warn("Exception while calling model listener", e2);
                    }
                });
                handler.onError(error);
            }

            public void onComplete(Response<AiMessage> response) {
                ChatResponse listenerResponse = InternalAnthropicHelper.createListenerResponse((String)response.metadata().get("id"), (String)response.metadata().get("model"), response);
                ChatModelResponseContext responseContext = new ChatModelResponseContext(listenerResponse, listenerRequest, AnthropicStreamingChatModel.this.provider(), attributes);
                AnthropicStreamingChatModel.this.listeners.forEach(listener -> {
                    try {
                        listener.onResponse(responseContext);
                    }
                    catch (Exception e) {
                        log.warn("Exception while calling model listener", e);
                    }
                });
                handler.onComplete(response);
                super.onComplete(response);
            }
        };
        this.client.createMessage(request, listenerHandler);
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.ANTHROPIC;
    }

    public static class AnthropicStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String version;
        private String beta;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Integer maxTokens;
        private List<String> stopSequences;
        private Boolean cacheSystemMessages;
        private Boolean cacheTools;
        private String thinkingType;
        private Integer thinkingBudgetTokens;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;

        public AnthropicStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public AnthropicStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AnthropicStreamingChatModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnthropicStreamingChatModelBuilder beta(String beta) {
            this.beta = beta;
            return this;
        }

        public AnthropicStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public AnthropicStreamingChatModelBuilder modelName(AnthropicChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public AnthropicStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicStreamingChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicStreamingChatModelBuilder cacheSystemMessages(Boolean cacheSystemMessages) {
            this.cacheSystemMessages = cacheSystemMessages;
            return this;
        }

        public AnthropicStreamingChatModelBuilder cacheTools(Boolean cacheTools) {
            this.cacheTools = cacheTools;
            return this;
        }

        public AnthropicStreamingChatModelBuilder thinkingType(String thinkingType) {
            this.thinkingType = thinkingType;
            return this;
        }

        public AnthropicStreamingChatModelBuilder thinkingBudgetTokens(Integer thinkingBudgetTokens) {
            this.thinkingBudgetTokens = thinkingBudgetTokens;
            return this;
        }

        public AnthropicStreamingChatModelBuilder timeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        public AnthropicStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public AnthropicStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AnthropicStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public AnthropicStreamingChatModel build() {
            return new AnthropicStreamingChatModel(this.baseUrl, this.apiKey, this.version, this.beta, this.modelName, this.temperature, this.topP, this.topK, this.maxTokens, this.stopSequences, this.cacheSystemMessages, this.cacheTools, this.thinkingType, this.thinkingBudgetTokens, this.timeout, this.logRequests, this.logResponses, this.listeners);
        }
    }
}

