/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.codeGen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dataframe.impl.codeGen.CodeGenResult;
import org.jetbrains.dataframe.keywords.HardKeywords;
import org.jetbrains.dataframe.keywords.ModifierKeywords;
import org.jetbrains.kotlinx.dataframe.codeGen.CodeWithConverter;
import org.jetbrains.kotlinx.dataframe.codeGen.Marker;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u001a\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\b\u0012\u0004\u0012\u00020\u00110\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\n\u0010\u0015\u001a\u00020\u000e*\u00020\n\u001a\u0016\u0010\u0016\u001a\u00020\n*\f\u0012\b\u0012\u00060\nj\u0002`\u00170\u0010H\u0000\u001a\f\u0010\u0018\u001a\u00020\u000e*\u00020\nH\u0000\u001a\n\u0010\u0019\u001a\u00020\n*\u00020\n\u001a \u0010\u001a\u001a\u00020\n*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0010\u001a \u0010\u001a\u001a\u00020\n*\u00020\b2\u0006\u0010\u001c\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0010\u001a$\u0010\u001a\u001a\u00020\n*\u00060\nj\u0002`\u00172\u0006\u0010\u001c\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0010\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"charsToQuote", "Lkotlin/text/Regex;", "getCharsToQuote", "()Lkotlin/text/Regex;", "letterCategories", "", "Lkotlin/text/CharCategory;", "createCodeWithConverter", "Lorg/jetbrains/kotlinx/dataframe/codeGen/CodeWithConverter;", "code", "", "markerName", "renderNullability", "nullable", "", "filterRequiredForSchema", "", "Lorg/jetbrains/kotlinx/dataframe/codeGen/Marker;", "", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "isQuoted", "join", "Lorg/jetbrains/kotlinx/jupyter/api/Code;", "needsQuoting", "quoteIfNeeded", "toStandaloneSnippet", "Lorg/jetbrains/dataframe/impl/codeGen/CodeGenResult;", "packageName", "additionalImports", "core"})
@SourceDebugExtension(value={"SMAP\nCodeGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeGeneratorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/codeGen/CodeGeneratorImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,534:1\n766#2:535\n857#2,2:536\n1855#2,2:542\n1064#3,2:538\n1083#3,2:540\n*S KotlinDebug\n*F\n+ 1 CodeGeneratorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/codeGen/CodeGeneratorImplKt\n*L\n41#1:535\n41#1:536,2\n525#1:542,2\n63#1:538,2\n64#1:540,2\n*E\n"})
public final class CodeGeneratorImplKt {
    @NotNull
    private static final Regex charsToQuote = new Regex("[ `(){}\\[\\].<>'\"/|\\\\!?@:;%^&*#$-]");
    @NotNull
    private static final Set<CharCategory> letterCategories;

    private static final String renderNullability(boolean nullable) {
        return nullable ? "?" : "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Marker> filterRequiredForSchema(@NotNull Iterable<? extends Marker> $this$filterRequiredForSchema, @NotNull DataFrameSchema schema2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterRequiredForSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        Iterable<? extends Marker> $this$filter$iv = $this$filterRequiredForSchema;
        boolean $i$f$filter = false;
        Iterable<? extends Marker> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Marker it = (Marker)element$iv$iv;
            boolean bl = false;
            if (!(it.isOpen() && it.getSchema().compare(schema2).isSuperOrEqual())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Regex getCharsToQuote() {
        return charsToQuote;
    }

    @NotNull
    public static final CodeWithConverter createCodeWithConverter(@NotNull String code2, @NotNull String markerName) {
        Intrinsics.checkNotNullParameter((Object)code2, (String)"code");
        Intrinsics.checkNotNullParameter((Object)markerName, (String)"markerName");
        return new CodeWithConverter(code2, (Function1<? super String, String>)((Function1)new Function1<String, String>(markerName){
            final /* synthetic */ String $markerName;
            {
                this.$markerName = $markerName;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it + ".cast<" + this.$markerName + ">()";
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean needsQuoting(@NotNull String $this$needsQuoting) {
        char it;
        char element$iv;
        int n;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$needsQuoting, (String)"<this>");
            if (CodeGeneratorImplKt.isQuoted($this$needsQuoting)) {
                return false;
            }
            if (StringsKt.isBlank((CharSequence)$this$needsQuoting)) return true;
            if (Character.isDigit(StringsKt.first((CharSequence)$this$needsQuoting))) return true;
            CharSequence charSequence = $this$needsQuoting;
            if (charsToQuote.containsMatchIn(charSequence)) return true;
            if (HardKeywords.Companion.getVALUES().contains($this$needsQuoting)) return true;
            if (ModifierKeywords.Companion.getVALUES().contains($this$needsQuoting)) return true;
            CharSequence $this$all$iv = $this$needsQuoting;
            boolean $i$f$all = false;
            n = 0;
            while (n < $this$all$iv.length()) {
                it = element$iv = $this$all$iv.charAt(n);
                boolean bl = false;
                if (it == '_') {
                    ++n;
                    continue;
                }
                break block6;
            }
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        CharSequence $this$any$iv = $this$needsQuoting;
        boolean $i$f$any = false;
        n = 0;
        while (n < $this$any$iv.length()) {
            it = element$iv = $this$any$iv.charAt(n);
            boolean bl2 = false;
            if (it != '_' && !letterCategories.contains(CharsKt.getCategory((char)it))) {
                return true;
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuoted, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isQuoted, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$isQuoted, (String)"`", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String quoteIfNeeded(@NotNull String $this$quoteIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$quoteIfNeeded, (String)"<this>");
        return CodeGeneratorImplKt.needsQuoting($this$quoteIfNeeded) ? '`' + $this$quoteIfNeeded + '`' : $this$quoteIfNeeded;
    }

    @NotNull
    public static final String join(@NotNull List<String> $this$join) {
        Intrinsics.checkNotNullParameter($this$join, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$join, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull CodeWithConverter $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        return CodeGeneratorImplKt.toStandaloneSnippet($this$toStandaloneSnippet.getDeclarations(), packageName, additionalImports);
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull String $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        StringBuilder $this$toStandaloneSnippet_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)packageName).length() > 0) {
            StringBuilder stringBuilder2 = $this$toStandaloneSnippet_u24lambda_u244.append("package " + packageName);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$toStandaloneSnippet_u24lambda_u244.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder3 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.ColumnsContainer");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.DataColumn");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.DataFrame");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.DataRow");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder8 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.annotations.ColumnName");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder9 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.annotations.DataSchema");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder10 = $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.api.cast");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = additionalImports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder11 = $this$toStandaloneSnippet_u24lambda_u244.append(it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$toStandaloneSnippet_u24lambda_u244.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder12 = $this$toStandaloneSnippet_u24lambda_u244.append($this$toStandaloneSnippet);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull CodeGenResult $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        return CodeGeneratorImplKt.toStandaloneSnippet($this$toStandaloneSnippet.getCode(), packageName, additionalImports);
    }

    public static final /* synthetic */ String access$renderNullability(boolean nullable) {
        return CodeGeneratorImplKt.renderNullability(nullable);
    }

    static {
        Object[] objectArray = new CharCategory[]{CharCategory.UPPERCASE_LETTER, CharCategory.TITLECASE_LETTER, CharCategory.MODIFIER_LETTER, CharCategory.LOWERCASE_LETTER, CharCategory.DECIMAL_DIGIT_NUMBER};
        letterCategories = SetsKt.setOf((Object[])objectArray);
    }
}

