/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.jupyter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.Convert;
import org.jetbrains.kotlinx.dataframe.api.FormatClause;
import org.jetbrains.kotlinx.dataframe.api.FormattedFrame;
import org.jetbrains.kotlinx.dataframe.api.FramesKt;
import org.jetbrains.kotlinx.dataframe.api.Gather;
import org.jetbrains.kotlinx.dataframe.api.GatherKt;
import org.jetbrains.kotlinx.dataframe.api.GroupBy;
import org.jetbrains.kotlinx.dataframe.api.GroupClause;
import org.jetbrains.kotlinx.dataframe.api.GroupKt;
import org.jetbrains.kotlinx.dataframe.api.InsertClause;
import org.jetbrains.kotlinx.dataframe.api.InsertKt;
import org.jetbrains.kotlinx.dataframe.api.Merge;
import org.jetbrains.kotlinx.dataframe.api.MergeKt;
import org.jetbrains.kotlinx.dataframe.api.MoveClause;
import org.jetbrains.kotlinx.dataframe.api.Pivot;
import org.jetbrains.kotlinx.dataframe.api.PivotGroupBy;
import org.jetbrains.kotlinx.dataframe.api.ReducedGroupBy;
import org.jetbrains.kotlinx.dataframe.api.ReducedPivot;
import org.jetbrains.kotlinx.dataframe.api.ReducedPivotGroupBy;
import org.jetbrains.kotlinx.dataframe.api.RenameClause;
import org.jetbrains.kotlinx.dataframe.api.ReplaceClause;
import org.jetbrains.kotlinx.dataframe.api.SortDsl;
import org.jetbrains.kotlinx.dataframe.api.SortKt;
import org.jetbrains.kotlinx.dataframe.api.Split;
import org.jetbrains.kotlinx.dataframe.api.SplitKt;
import org.jetbrains.kotlinx.dataframe.api.SplitWithTransform;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.api.Update;
import org.jetbrains.kotlinx.dataframe.api.ValuesKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.impl.ColumnNameGenerator;
import org.jetbrains.kotlinx.dataframe.jupyter.DisableRowsLimitWrapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u0001J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ \u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J&\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J:\u0010\u0016\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fJ@\u0010\u0016\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u00072\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u00072\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/dataframe/jupyter/KotlinNotebookPluginUtils;", "", "()V", "KTNB_IDE_BUILD_PROP", "", "convertToDataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "dataframeLike", "generateRandomVariationOfColumnName", "preferredName", "usedNames", "", "getKotlinNotebookIDEBuildNumber", "Lorg/jetbrains/kotlinx/dataframe/jupyter/KotlinNotebookPluginUtils$IdeBuildNumber;", "getRowsSubsetForRendering", "Lorg/jetbrains/kotlinx/dataframe/jupyter/DisableRowsLimitWrapper;", "dataFrameLike", "startIdx", "", "endIdx", "df", "sortByColumns", "columnPaths", "desc", "", "isDesc", "IdeBuildNumber", "core"})
public final class KotlinNotebookPluginUtils {
    @NotNull
    public static final KotlinNotebookPluginUtils INSTANCE = new KotlinNotebookPluginUtils();
    @NotNull
    private static final String KTNB_IDE_BUILD_PROP = "KTNB_IDE_BUILD_NUMBER";

    private KotlinNotebookPluginUtils() {
    }

    @NotNull
    public final DisableRowsLimitWrapper getRowsSubsetForRendering(@Nullable Object dataFrameLike, int startIdx, int endIdx) {
        if (dataFrameLike == null) {
            throw new IllegalArgumentException("Dataframe is null");
        }
        return this.getRowsSubsetForRendering(this.convertToDataFrame(dataFrameLike), startIdx, endIdx);
    }

    @NotNull
    public final DisableRowsLimitWrapper getRowsSubsetForRendering(@NotNull DataFrame<?> df2, int startIdx, int endIdx) {
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        return new DisableRowsLimitWrapper(df2.get(RangesKt.until((int)startIdx, (int)endIdx)));
    }

    @NotNull
    public final DataFrame<?> sortByColumns(@Nullable Object dataFrameLike, @NotNull List<? extends List<String>> columnPaths, @NotNull List<Boolean> desc) {
        Intrinsics.checkNotNullParameter(columnPaths, (String)"columnPaths");
        Intrinsics.checkNotNullParameter(desc, (String)"desc");
        if (dataFrameLike == null) {
            throw new IllegalArgumentException("Dataframe is null");
        }
        return this.sortByColumns(this.convertToDataFrame(dataFrameLike), columnPaths, desc);
    }

    @NotNull
    public final DataFrame<?> sortByColumns(@NotNull DataFrame<?> df2, @NotNull List<? extends List<String>> columnPaths, @NotNull List<Boolean> isDesc) {
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        Intrinsics.checkNotNullParameter(columnPaths, (String)"columnPaths");
        Intrinsics.checkNotNullParameter(isDesc, (String)"isDesc");
        return SortKt.sortBy(df2, (Function2)new Function2<SortDsl<? extends Object>, SortDsl<? extends Object>, ColumnsResolver<? extends Object>>(columnPaths, isDesc){
            final /* synthetic */ List<List<String>> $columnPaths;
            final /* synthetic */ List<Boolean> $isDesc;
            {
                this.$columnPaths = $columnPaths;
                this.$isDesc = $isDesc;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ColumnsResolver<Object> invoke(@NotNull SortDsl<? extends Object> $this$sortBy, @NotNull SortDsl<? extends Object> it) {
                Collection collection;
                List list;
                Iterable $this$mapTo$iv$iv;
                Object element$iv2;
                boolean bl;
                block7: {
                    Intrinsics.checkNotNullParameter($this$sortBy, (String)"$this$sortBy");
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Iterable $this$all$iv = this.$columnPaths;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            List it2 = (List)element$iv2;
                            boolean bl2 = false;
                            if (!((Collection)it2).isEmpty()) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (!bl) {
                    String $i$f$all = "Failed requirement.";
                    throw new IllegalArgumentException($i$f$all.toString());
                }
                if (!(this.$columnPaths.size() == this.$isDesc.size())) {
                    String $i$f$all = "Failed requirement.";
                    throw new IllegalArgumentException($i$f$all.toString());
                }
                Iterable $this$map$iv = this.$columnPaths;
                boolean $i$f$map = false;
                element$iv2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void path;
                    list = (List)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new ColumnPath((List<String>)path));
                }
                List sortKeys = (List)destination$iv$iv;
                $this$map$iv = CollectionsKt.zip((Iterable)sortKeys, (Iterable)this.$isDesc);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    list = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    ColumnPath key = (ColumnPath)list.component1();
                    boolean desc = (Boolean)list.component2();
                    collection.add(desc ? $this$sortBy.desc(key) : (SingleColumn<C>)key);
                }
                return org.jetbrains.kotlinx.dataframe.columns.ConstructorsKt.toColumnSet((List)destination$iv$iv);
            }
        });
    }

    @NotNull
    public final DataFrame<?> convertToDataFrame(@NotNull Object dataframeLike) {
        DataFrame<Object> dataFrame;
        Intrinsics.checkNotNullParameter((Object)dataframeLike, (String)"dataframeLike");
        Object object = dataframeLike;
        if (object instanceof Pivot) {
            dataFrame = TypeConversionsKt.toDataFrame(FramesKt.frames((Pivot)dataframeLike));
        } else if (object instanceof ReducedGroupBy) {
            dataFrame = ValuesKt.values((ReducedGroupBy)dataframeLike);
        } else if (object instanceof ReducedPivot) {
            dataFrame = TypeConversionsKt.toDataFrame(ValuesKt.values$default((ReducedPivot)dataframeLike, false, 1, null));
        } else if (object instanceof PivotGroupBy) {
            dataFrame = FramesKt.frames((PivotGroupBy)dataframeLike);
        } else if (object instanceof ReducedPivotGroupBy) {
            dataFrame = ValuesKt.values$default((ReducedPivotGroupBy)dataframeLike, false, 1, null);
        } else if (object instanceof SplitWithTransform) {
            dataFrame = SplitKt.into$default((SplitWithTransform)dataframeLike, new String[0], null, 2, null);
        } else if (object instanceof Split) {
            dataFrame = SplitKt.toDataFrame((Split)dataframeLike);
        } else if (object instanceof Merge) {
            dataFrame = MergeKt.into((Merge)dataframeLike, this.generateRandomVariationOfColumnName("merged", ((Merge)dataframeLike).getDf().columnNames()));
        } else if (object instanceof Gather) {
            dataFrame = GatherKt.into((Gather)dataframeLike, this.generateRandomVariationOfColumnName("key", ((Gather)dataframeLike).getDf$core().columnNames()), this.generateRandomVariationOfColumnName("value", ((Gather)dataframeLike).getDf$core().columnNames()));
        } else if (object instanceof Update) {
            dataFrame = ((Update)dataframeLike).getDf();
        } else if (object instanceof Convert) {
            dataFrame = ((Convert)dataframeLike).getDf();
        } else if (object instanceof FormattedFrame) {
            dataFrame = ((FormattedFrame)dataframeLike).getDf$core();
        } else if (object instanceof DataColumn) {
            BaseColumn[] baseColumnArray = new BaseColumn[]{dataframeLike};
            dataFrame = ConstructorsKt.dataFrameOf(baseColumnArray);
        } else if (object instanceof DataRow) {
            dataFrame = TypeConversionsKt.toDataFrame((DataRow)dataframeLike);
        } else if (object instanceof GroupBy) {
            dataFrame = GroupBy.DefaultImpls.toDataFrame$default((GroupBy)dataframeLike, null, 1, null);
        } else if (object instanceof DataFrame) {
            dataFrame = (DataFrame)dataframeLike;
        } else if (object instanceof DisableRowsLimitWrapper) {
            dataFrame = ((DisableRowsLimitWrapper)dataframeLike).getValue();
        } else if (object instanceof MoveClause) {
            dataFrame = ((MoveClause)dataframeLike).getDf$core();
        } else if (object instanceof RenameClause) {
            dataFrame = ((RenameClause)dataframeLike).getDf();
        } else if (object instanceof ReplaceClause) {
            dataFrame = ((ReplaceClause)dataframeLike).getDf();
        } else if (object instanceof GroupClause) {
            dataFrame = GroupKt.into((GroupClause)dataframeLike, this.generateRandomVariationOfColumnName("untitled", ((GroupClause)dataframeLike).getDf().columnNames()));
        } else if (object instanceof InsertClause) {
            dataFrame = InsertKt.at((InsertClause)dataframeLike, 0);
        } else if (object instanceof FormatClause) {
            dataFrame = ((FormatClause)dataframeLike).getDf();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + Reflection.getOrCreateKotlinClass(dataframeLike.getClass()));
        }
        return dataFrame;
    }

    @NotNull
    public final String generateRandomVariationOfColumnName(@NotNull String preferredName, @NotNull List<String> usedNames) {
        Intrinsics.checkNotNullParameter((Object)preferredName, (String)"preferredName");
        Intrinsics.checkNotNullParameter(usedNames, (String)"usedNames");
        return new ColumnNameGenerator(usedNames).addUnique(preferredName);
    }

    public static /* synthetic */ String generateRandomVariationOfColumnName$default(KotlinNotebookPluginUtils kotlinNotebookPluginUtils, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return kotlinNotebookPluginUtils.generateRandomVariationOfColumnName(string, list);
    }

    @Nullable
    public final IdeBuildNumber getKotlinNotebookIDEBuildNumber() {
        String string = System.getProperty(KTNB_IDE_BUILD_PROP, null);
        if (string == null) {
            return null;
        }
        String value = string;
        return IdeBuildNumber.Companion.fromString(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dataframe/jupyter/KotlinNotebookPluginUtils$IdeBuildNumber;", "", "ideName", "", "majorVersion", "", "buildId", "(Ljava/lang/String;II)V", "getBuildId", "()I", "getIdeName", "()Ljava/lang/String;", "getMajorVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "core"})
    public static final class IdeBuildNumber {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String ideName;
        private final int majorVersion;
        private final int buildId;

        public IdeBuildNumber(@NotNull String ideName, int majorVersion, int buildId) {
            Intrinsics.checkNotNullParameter((Object)ideName, (String)"ideName");
            this.ideName = ideName;
            this.majorVersion = majorVersion;
            this.buildId = buildId;
        }

        @NotNull
        public final String getIdeName() {
            return this.ideName;
        }

        public final int getMajorVersion() {
            return this.majorVersion;
        }

        public final int getBuildId() {
            return this.buildId;
        }

        @NotNull
        public final String component1() {
            return this.ideName;
        }

        public final int component2() {
            return this.majorVersion;
        }

        public final int component3() {
            return this.buildId;
        }

        @NotNull
        public final IdeBuildNumber copy(@NotNull String ideName, int majorVersion, int buildId) {
            Intrinsics.checkNotNullParameter((Object)ideName, (String)"ideName");
            return new IdeBuildNumber(ideName, majorVersion, buildId);
        }

        public static /* synthetic */ IdeBuildNumber copy$default(IdeBuildNumber ideBuildNumber, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = ideBuildNumber.ideName;
            }
            if ((n3 & 2) != 0) {
                n = ideBuildNumber.majorVersion;
            }
            if ((n3 & 4) != 0) {
                n2 = ideBuildNumber.buildId;
            }
            return ideBuildNumber.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "IdeBuildNumber(ideName=" + this.ideName + ", majorVersion=" + this.majorVersion + ", buildId=" + this.buildId + ')';
        }

        public int hashCode() {
            int result2 = this.ideName.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.majorVersion);
            result2 = result2 * 31 + Integer.hashCode(this.buildId);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdeBuildNumber)) {
                return false;
            }
            IdeBuildNumber ideBuildNumber = (IdeBuildNumber)other;
            if (!Intrinsics.areEqual((Object)this.ideName, (Object)ideBuildNumber.ideName)) {
                return false;
            }
            if (this.majorVersion != ideBuildNumber.majorVersion) {
                return false;
            }
            return this.buildId == ideBuildNumber.buildId;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/dataframe/jupyter/KotlinNotebookPluginUtils$IdeBuildNumber$Companion;", "", "()V", "constructIdeBuildNumber", "Lorg/jetbrains/kotlinx/dataframe/jupyter/KotlinNotebookPluginUtils$IdeBuildNumber;", "parts", "", "", "fromString", "buildNumber", "core"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final IdeBuildNumber fromString(@NotNull String buildNumber) {
                Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
                String[] stringArray = new String[]{";"};
                List parts = StringsKt.split$default((CharSequence)buildNumber, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                return parts.size() >= 3 ? this.constructIdeBuildNumber(parts) : null;
            }

            private final IdeBuildNumber constructIdeBuildNumber(List<String> parts) {
                String ideName = parts.get(0);
                Integer majorVersion = StringsKt.toIntOrNull((String)parts.get(1));
                Integer buildId = StringsKt.toIntOrNull((String)parts.get(2));
                return majorVersion != null && buildId != null ? new IdeBuildNumber(ideName, majorVersion, buildId) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

