/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.template;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.template.TemplateLanguageFileUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTemplateLanguageFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Language myTemplateDataLanguage;
    private final Set<Language> myLanguages;

    public AbstractTemplateLanguageFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            AbstractTemplateLanguageFileViewProvider.A(0);
        }
        if (virtualFile == null) {
            AbstractTemplateLanguageFileViewProvider.A(1);
        }
        this(manager, virtualFile, eventSystemEnabled, TemplateLanguageFileUtil.getTemplateDataLanguage(manager.getProject(), virtualFile));
    }

    protected AbstractTemplateLanguageFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language templateDataLanguage) {
        if (manager == null) {
            AbstractTemplateLanguageFileViewProvider.A(2);
        }
        if (virtualFile == null) {
            AbstractTemplateLanguageFileViewProvider.A(3);
        }
        if (templateDataLanguage == null) {
            AbstractTemplateLanguageFileViewProvider.A(4);
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myLanguages = new HashSet<Language>();
        this.myTemplateDataLanguage = templateDataLanguage;
        this.myLanguages.add(this.getBaseLanguage());
        this.myLanguages.add(this.myTemplateDataLanguage);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            AbstractTemplateLanguageFileViewProvider.A(5);
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myLanguages;
        if (set == null) {
            AbstractTemplateLanguageFileViewProvider.A(6);
        }
        return set;
    }

    protected abstract IElementType getTemplateDataType();

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            AbstractTemplateLanguageFileViewProvider.A(7);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl psiFileImpl = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
            psiFileImpl.setContentElementType(this.getTemplateDataType());
            return psiFileImpl;
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        return null;
    }

    private static /* synthetic */ void A(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDataLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/template/AbstractTemplateLanguageFileViewProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

