/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseCreateGenerator;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateLikeTable;
import com.intellij.database.dialects.base.generator.producers.ProducerUtilsKt;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingUtilsKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\"\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\nH\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u0019*\u00060\u001bR\u00020\u0005H\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\nH\u0014J\b\u0010 \u001a\u00020\u001dH\u0014J\u0017\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\"J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u000fH\u0014R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/base/generator/producers/CreateTable;", "T", "Lcom/intellij/database/model/basic/BasicTable;", "Lcom/intellij/database/dialects/base/generator/producers/CreateLikeTable;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/basic/BasicTable;)V", "register", "Lcom/intellij/database/dialects/base/generator/Operation;", "generator", "Lcom/intellij/database/dialects/base/generator/BaseCreateGenerator;", "root", "skipKindRegistration", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "shouldGenerateOutside", "it", "Lcom/intellij/database/model/basic/BasicKey;", "registerColumn", "column", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "produceElementList", "", "produceHeader", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "header", "", "shouldProduceInElementList", "op", "makeCreateOrReplace", "elementKindNameForCreate", "(Lcom/intellij/database/model/basic/BasicTable;)Ljava/lang/String;", "tableElementsApplicableInExactTask", "", "canCreateInTable", "Lcom/intellij/database/model/basic/BasicElement;", "shouldProduceChildren", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nTableProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableProducers.kt\ncom/intellij/database/dialects/base/generator/producers/CreateTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1869#2,2:157\n1869#2,2:159\n1869#2,2:161\n1869#2,2:163\n1#3:165\n*S KotlinDebug\n*F\n+ 1 TableProducers.kt\ncom/intellij/database/dialects/base/generator/producers/CreateTable\n*L\n20#1:157,2\n21#1:159,2\n31#1:161,2\n32#1:163,2\n*E\n"})
public class CreateTable<T extends BasicTable>
extends CreateLikeTable<T> {
    @NotNull
    private final Set<ObjectKind> tableElementsApplicableInExactTask;

    public CreateTable(@NotNull ScriptingContext context, @NotNull T element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        super(context, (BasicLikeTable)element);
        Object[] objectArray = new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK};
        this.tableElementsApplicableInExactTask = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Operation register(@NotNull BaseCreateGenerator generator, @NotNull Operation root) {
        Operation operation;
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Operation $this$register_u24lambda_u245 = operation = super.register(generator, root);
        boolean bl = false;
        PositioningNamingFamily<? extends BasicTableOrViewColumn> positioningNamingFamily = ((BasicTableOrView)this.getElement()).getColumns();
        Intrinsics.checkNotNullExpressionValue(positioningNamingFamily, (String)"getColumns(...)");
        Iterable $this$forEach$iv = positioningNamingFamily;
        boolean bl2 = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicTableOrViewColumn basicTableOrViewColumn = (BasicTableOrViewColumn)element$iv;
            boolean bl22 = false;
            if (basicTableOrViewColumn.isAutoCreated()) continue;
            Intrinsics.checkNotNull((Object)basicTableOrViewColumn);
            this.registerColumn(generator, basicTableOrViewColumn, $this$register_u24lambda_u245);
        }
        NamingFamily<? extends BasicKey> namingFamily = ((BasicTableOrView)this.getElement()).getKeys();
        Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getKeys(...)");
        $this$forEach$iv = namingFamily;
        boolean bl3 = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation op;
            Operation desiredRoot;
            BasicKey basicKey = (BasicKey)element$iv;
            boolean bl32 = false;
            if (basicKey.isAutoCreated()) continue;
            Intrinsics.checkNotNull((Object)basicKey);
            if (!this.canCreateInTable(basicKey)) continue;
            Operation operation2 = desiredRoot = this.shouldGenerateOutside(basicKey) ? root : $this$register_u24lambda_u245;
            if (BaseCreateGenerator.prepareElement$default(generator, basicKey, desiredRoot, false, 4, null) == null) continue;
            boolean bl4 = false;
            Operation operation3 = (Operation)op.getParent();
            if ((operation3 != null ? ScenarioOperations.element(operation3) : null) instanceof BasicTableColumn) {
                Operation operation4 = (Operation)op.getParent();
                boolean bl5 = operation4 != null ? operation4.isProvided() : false;
                if (!bl5) continue;
            }
            op.setParent((Node)desiredRoot);
        }
        NamingFamily<? extends BasicForeignKey> namingFamily2 = ((BasicTableOrView)this.getElement()).getForeignKeys();
        Intrinsics.checkNotNullExpressionValue(namingFamily2, (String)"getForeignKeys(...)");
        $this$forEach$iv = namingFamily2;
        boolean bl6 = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicForeignKey basicForeignKey = (BasicForeignKey)element$iv;
            boolean bl62 = false;
            Intrinsics.checkNotNull((Object)basicForeignKey);
            if (!this.canCreateInTable(basicForeignKey)) continue;
            BaseCreateGenerator.prepareElement$default(generator, basicForeignKey, $this$register_u24lambda_u245, false, 4, null);
        }
        Family<? extends BasicIndex> family = ((BasicTableOrView)this.getElement()).getIndices();
        Intrinsics.checkNotNullExpressionValue(family, (String)"getIndices(...)");
        $this$forEach$iv = family;
        boolean bl7 = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicIndex basicIndex = (BasicIndex)element$iv;
            boolean bl72 = false;
            if (basicIndex.isAutoCreated()) continue;
            Intrinsics.checkNotNull((Object)basicIndex);
            if (!this.canCreateInTable(basicIndex)) continue;
            BaseCreateGenerator.prepareElement$default(generator, basicIndex, $this$register_u24lambda_u245, false, 4, null);
        }
        for (Family<? extends BasicElement> family2 : ((BasicMixinElement)this.getElement()).getFamilies()) {
            if (family2 == ((BasicTableOrView)this.getElement()).getColumns()) continue;
            Intrinsics.checkNotNull(family2);
            BasicElement basicElement = (BasicElement)CollectionsKt.firstOrNull((Iterable)family2);
            ObjectKind kind = basicElement != null ? basicElement.getKind() : null;
            if (kind == null || this.skipKindRegistration(kind) || !this.tableElementsApplicableInExactTask.contains(kind) && this.getTask().getCategory() == ScriptCategory.CREATE_DEFINITION) continue;
            for (BasicElement basicElement2 : family2) {
                if (basicElement2.isAutoCreated()) continue;
                Intrinsics.checkNotNull((Object)basicElement2);
                Operation operation5 = this.canCreateInTable(basicElement2) ? BaseCreateGenerator.prepareElement$default(generator, basicElement2, $this$register_u24lambda_u245, false, 4, null) : BaseCreateGenerator.prepareElement$default(generator, basicElement2, root, false, 4, null);
            }
        }
        return operation;
    }

    protected boolean skipKindRegistration(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return false;
    }

    protected final boolean shouldGenerateOutside(@NotNull BasicKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this.getContext().getHelper().shouldGenerateOutsideTable(this.getContext(), it);
    }

    @Nullable
    protected Operation registerColumn(@NotNull BaseCreateGenerator generator, @NotNull BasicTableOrViewColumn column2, @NotNull Operation root) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return BaseCreateGenerator.prepareElement$default(generator, column2, root, false, 4, null);
    }

    @Override
    protected void produceElementList() {
        this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> CreateTable.produceElementList$lambda$8(this, arg_0)));
    }

    @Override
    protected void produceHeader(@NotNull ScriptingContext.NewCodingAdapter $this$produceHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$produceHeader, (String)"<this>");
        $this$produceHeader.unaryPlus(this.header());
    }

    @Nullable
    protected String header() {
        String name2 = this.fqName();
        String temporary = ((BasicTableOrView)this.getElement()).isTemporary() ? "temporary" : null;
        String[] stringArray = new String[5];
        stringArray[0] = this.makeCreateOrReplace();
        stringArray[1] = temporary;
        String string = this.elementKindNameForCreate((BasicTable)this.getElement());
        if (string == null) {
            string = "table";
        }
        stringArray[2] = string;
        ElementProducer elementProducer = this;
        ObjectKind objectKind = ((DasNamed)this.getElement()).getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        stringArray[3] = ProducerUtilsKt.ifNotExists(elementProducer, objectKind, true);
        stringArray[4] = name2;
        return ScriptingUtilsKt.phrase(stringArray);
    }

    protected boolean shouldProduceInElementList(@NotNull Operation op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        BasicElement basicElement = ScenarioOperations.element(op);
        return !Intrinsics.areEqual((Object)(basicElement != null ? basicElement.getKind() : null), (Object)ObjectKind.PARTITION);
    }

    @NotNull
    protected String makeCreateOrReplace() {
        ElementProducer elementProducer = this;
        ObjectKind objectKind = ((DasNamed)this.getElement()).getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        return ProducerUtilsKt.createOrReplace(elementProducer, objectKind);
    }

    @Nullable
    protected String elementKindNameForCreate(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return Intrinsics.areEqual((Object)((DasNamed)element).getKind(), (Object)ObjectKind.TABLE) ? "table" : null;
    }

    private final boolean canCreateInTable(BasicElement element) {
        return this.getContext().getHelper().canGenerateHere(this.getContext(), ScriptLocus.IN_TABLE, element);
    }

    @Override
    protected boolean shouldProduceChildren() {
        Object v0;
        block1: {
            Iterable iterable = this.getNestedOperations();
            for (Object t : iterable) {
                Operation it = (Operation)t;
                boolean bl = false;
                if (!(!it.isProvided())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private static final Unit produceElementList$lambda$8$lambda$6(CreateTable this$0, ScriptingContext.NewCodingAdapter $this_sqlClause, LinkedHashSet $filtered, Operation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isProvided() || !this$0.shouldProduceInElementList(it)) {
            return Unit.INSTANCE;
        }
        BasicElement basicElement = ScenarioOperations.element(it);
        if (Intrinsics.areEqual((Object)(basicElement != null ? basicElement.getKind() : null), (Object)ObjectKind.COLUMN)) {
            this$0.produceChild($this_sqlClause, it);
        } else {
            ((Collection)$filtered).add(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit produceElementList$lambda$8$lambda$7(CreateTable this$0, ScriptingContext.NewCodingAdapter $this_sqlClause, Operation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.produceChild($this_sqlClause, it);
        return Unit.INSTANCE;
    }

    private static final Unit produceElementList$lambda$8(CreateTable this$0, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        LinkedHashSet filtered = new LinkedHashSet();
        this$0.processOperationsNoDeps((Function1<? super Operation, Unit>)((Function1)arg_0 -> CreateTable.produceElementList$lambda$8$lambda$6(this$0, $this$sqlClause, filtered, arg_0)));
        AbstractCodeGeneratorKt.processOperations(this$0.getContext(), filtered, (Function1<? super Operation, Unit>)((Function1)arg_0 -> CreateTable.produceElementList$lambda$8$lambda$7(this$0, $this$sqlClause, arg_0)));
        return Unit.INSTANCE;
    }
}

