/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends AbstractDatabaseDialect {
    protected PgDialectBase(@NotNull TypeHelper typeHelper) {
        if (typeHelper == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        super(typeHelper);
    }

    @Override
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        return "E'\\\\x" + ObjectFormatterUtil.toHexString((byte[])binaryData) + "'";
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        if (procedure == null) {
            PgDialectBase.$$$reportNull$$$0(3);
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef(procedure).symbol("(");
        boolean first2 = true;
        for (DasArgument arg : DasUtil.getParameters(procedure)) {
            ArgumentDirection direction = arg.getArgumentDirection();
            if (direction != ArgumentDirection.IN && direction != ArgumentDirection.INOUT) continue;
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type(arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(4);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            PgDialectBase.$$$reportNull$$$0(5);
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first2 = true;
        for (ObjectPath e : path.elements) {
            if (!first2) {
                builder.plain(", ");
            }
            first2 = false;
            builder.identifier(e.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2, boolean longMode, boolean withReturn) {
        if (builder == null) {
            PgDialectBase.$$$reportNull$$$0(6);
        }
        if (routine2 == null) {
            PgDialectBase.$$$reportNull$$$0(7);
        }
        JBIterable<? extends DasArgument> parameters = DasUtil.getParameters(routine2);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine2.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDasType().getSpecification();
        }
        int outs = 0;
        for (DasArgument parameter : parameters) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs;
        }
        builder.symbol("(");
        boolean first2 = true;
        for (DasArgument parameter : parameters) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            ArgumentDirection argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier(parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type(parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs == 1) {
                for (DasArgument parameter : parameters) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDasType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            PgDialectBase.$$$reportNull$$$0(9);
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnectionCore connection) throws Exception {
        if (element == null) {
            PgDialectBase.$$$reportNull$$$0(10);
        }
        if (connection == null) {
            PgDialectBase.$$$reportNull$$$0(11);
        }
        Dbms dbms = connection.getDbms();
        Map<String, Object> map = DbImplUtilCore.resultRowAsMap(connection, String.format("SELECT CAST(reltuples as INT) as rows, pg_catalog.pg_size_pretty(pg_catalog.pg_total_relation_size(C.oid)) \"Size\" FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtilCore.escapeSql(DasUtil.getSchema(element), true, dbms), DbImplUtilCore.escapeSql(element.getName(), true, dbms)));
        if (map == null) {
            PgDialectBase.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    protected String getSearchPathQuery() {
        return "select current_database() as a, current_schemas(false) as b";
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection) throws SQLException {
        if (connection == null) {
            PgDialectBase.$$$reportNull$$$0(13);
        }
        Map<String, Object> map = DbImplUtilCore.resultRowAsMap(connection, this.getSearchPathQuery());
        String db = String.valueOf(map.get("a"));
        Object[] schemas = (Object[])ObjectUtils.tryCast((Object)map.get("b"), Object[].class);
        if (StringUtil.isEmpty((String)db) || schemas == null || schemas.length == 0) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create(db, ObjectKind.DATABASE);
        return SearchPath.of(JBIterable.of((Object[])schemas).filter(String.class).transform(s -> dbPath.append((String)s, ObjectKind.SCHEMA)).toList());
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnectionCore connection) throws SQLException {
        if (connection == null) {
            PgDialectBase.$$$reportNull$$$0(14);
        }
        List<String> list = DbImplUtilCore.executeAndGetResult(connection, "SELECT datname as name FROM pg_database WHERE datistemplate = false", DbImplUtilCore.RS_AS_STRING_LIST);
        if (list == null) {
            PgDialectBase.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgDialectBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgDialectBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 12, 15 -> new IllegalStateException(string);
        };
    }
}

