/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u001a\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/redis/generator/RedisNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "<init>", "()V", "escapableCharacters", "", "", "keyObjectKinds", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "catToScript", "", "catName", "kind", "plain", "", "openingQuotes", "forceQuoting", "isEscapable", "escape", "Provider", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nRedisNamingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisNamingService.kt\ncom/intellij/database/dialects/redis/generator/RedisNamingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,36:1\n1#2:37\n847#3:38\n887#3,5:39\n*S KotlinDebug\n*F\n+ 1 RedisNamingService.kt\ncom/intellij/database/dialects/redis/generator/RedisNamingService\n*L\n33#1:38\n33#1:39,5\n*E\n"})
public final class RedisNamingService
extends AbstractNamingService {
    @NotNull
    public static final RedisNamingService INSTANCE = new RedisNamingService();
    @NotNull
    private static final List<Character> escapableCharacters;
    @NotNull
    private static final List<ObjectKind> keyObjectKinds;

    private RedisNamingService() {
        Dbms dbms = RedisDbms.REDIS;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"REDIS");
        Pattern pattern = Pattern.compile("[^\\s']+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Casing casing = CasingProvider.EXACT_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"EXACT_CASING");
        super(dbms, pattern, casing);
    }

    @Override
    @NotNull
    public String catToScript(@NotNull String catName, @Nullable ObjectKind kind, boolean plain, @Nullable String openingQuotes, boolean forceQuoting) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        return super.catToScript(this.escape(catName, kind), kind, plain, openingQuotes, forceQuoting);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEscapable(String catName, ObjectKind kind) {
        char c2;
        block2: {
            if (kind == null) return false;
            if (!keyObjectKinds.contains(kind)) return false;
            CharSequence charSequence = catName;
            int n = 0;
            while (n < charSequence.length()) {
                char it = c2 = charSequence.charAt(n);
                boolean bl = false;
                if (!escapableCharacters.contains(Character.valueOf(it))) {
                    ++n;
                    continue;
                }
                break block2;
            }
            return false;
        }
        Character c3 = Character.valueOf(c2);
        if (c3 == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final String escape(String catName, ObjectKind kind) {
        void $this$flatMapTo$iv$iv;
        if (!this.isEscapable(catName, kind)) {
            return catName;
        }
        CharSequence $this$flatMap$iv = catName;
        boolean $i$f$flatMap = false;
        CharSequence charSequence = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (int j = 0; j < $this$flatMapTo$iv$iv.length(); ++j) {
            List list;
            char element$iv$iv;
            char it = element$iv$iv = $this$flatMapTo$iv$iv.charAt(j);
            boolean bl = false;
            if (escapableCharacters.contains(Character.valueOf(it))) {
                Object[] objectArray = new Character[]{Character.valueOf('\\'), Character.valueOf(it)};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)Character.valueOf(it));
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('\"'), Character.valueOf('\\')};
        escapableCharacters = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new ObjectKind[]{ObjectKind.COLLECTION, ObjectKind.STRING, ObjectKind.LIST, ObjectKind.SET, ObjectKind.SORTED_SET, ObjectKind.HASH_TABLE, ObjectKind.STREAM, ObjectKind.JSON_DOCUMENT, ObjectKind.DATA_STRUCTURE};
        keyObjectKinds = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/redis/generator/RedisNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "<init>", "()V", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.redis"})
    public static final class Provider
    implements NamingService.Provider {
        @Override
        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
            return INSTANCE;
        }
    }
}

