/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.highlight;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.linter.JSLinterSuppressionUtil;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintSuppressionUtil
extends JSLinterSuppressionUtil {
    public static final TsLintSuppressionUtil INSTANCE = new TsLintSuppressionUtil();
    private static final String LINE_COMMENT_PREFIX = "tslint:disable-next-line";
    private static final Pattern LINE_SUPPRESSION_PATTERN = Pattern.compile("(?://|/\\*)\\s*tslint:disable-next-line:\\s*(.*?)(?:\\*/)?");
    private static final Pattern FILE_SUPPRESSION_PATTERN = Pattern.compile("/\\*\\s*tslint:disable:\\s*(.*?)\\s*\\*/");
    private static final String FILE_COMMENT_PREFIX = "tslint:disable";

    private TsLintSuppressionUtil() {
    }

    @Nullable
    protected String getRulesFromFileLevelComment(@NotNull PsiComment comment) {
        Matcher matcher;
        if (comment == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(0);
        }
        if (comment.getNode().getElementType() != JSTokenTypes.C_STYLE_COMMENT) {
            return null;
        }
        String text = comment.getText();
        if (text.contains(FILE_COMMENT_PREFIX) && (matcher = FILE_SUPPRESSION_PATTERN.matcher(text)).matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    @Nullable
    protected String getRulesFromLineSuppressionComment(@NotNull PsiComment comment) {
        Matcher matcher;
        String text;
        if (comment == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(1);
        }
        if ((text = comment.getText()).contains(LINE_COMMENT_PREFIX) && (matcher = LINE_SUPPRESSION_PATTERN.matcher(text)).matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    @NotNull
    protected String getToolName() {
        String string = TsLintBundle.message("tslint.framework.title", new Object[0]);
        if (string == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String buildFileCommentText(@Nullable String existing, @Nullable String toAdd) {
        return TsLintSuppressionUtil.getCommentText(FILE_COMMENT_PREFIX, existing, toAdd);
    }

    @NotNull
    protected String buildLineCommentText(@Nullable String ruleCode, @Nullable String existingSuppressions) {
        return TsLintSuppressionUtil.getCommentText(LINE_COMMENT_PREFIX, existingSuppressions, ruleCode);
    }

    @NotNull
    private static String getCommentText(String prefix, @Nullable String existing, @Nullable String toAdd) {
        if (toAdd == null) {
            String string = prefix;
            if (string == null) {
                TsLintSuppressionUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String rules = StringUtil.isEmpty((String)existing) ? toAdd : existing + " " + toAdd;
        String string = prefix + (String)(StringUtil.isEmpty((String)rules) ? "" : ":" + rules);
        if (string == null) {
            TsLintSuppressionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/highlight/TsLintSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/highlight/TsLintSuppressionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRulesFromFileLevelComment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRulesFromLineSuppressionComment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

